/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.service.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.eye.api.dbmonitor.commons.JDBCConnectionHelper;
import kd.bos.eye.api.dbmonitor.entity.vo.KillSqlParam;
import kd.bos.eye.api.dbmonitor.service.SqlKiller;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class MySQLSqlKiller
implements SqlKiller,
JDBCConnectionHelper {
    private static final Log log = LogFactory.getLog(MySQLSqlKiller.class);

    @Override
    public void kill(KillSqlParam db) {
        String database = StringUtils.isEmpty((String)db.getSysDBName()) ? "information_schema" : db.getSysDBName();
        try (Connection conn = this.getConnection("jdbc:mysql://" + db.getAddress() + "/" + database, db);
             Statement stmt = conn.createStatement();){
            stmt.execute(" KILL QUERY " + db.getId());
        }
        catch (ClassNotFoundException | SQLException e) {
            if (e.getMessage().contains("Unknown thread id:")) {
                log.warn("thread id={},has ended", (Object)db.getId());
            }
            log.error("MySQL kill query error: ", (Throwable)e);
            throw new KDException("kill query failed cause by: " + e.getMessage());
        }
    }
}

