/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dbmonitor.commons.JDBCConnectionHelper;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessExecParam;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessInfoVo;
import kd.bos.eye.api.dbmonitor.service.ProcessListExecutor;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OracleProcessListExecutor
implements ProcessListExecutor,
JDBCConnectionHelper {
    private static final Log log = LogFactory.getLog(OracleProcessListExecutor.class);

    @Override
    public List<ProcessInfoVo> querySQLSnapshot(ProcessExecParam db) {
        ArrayList<ProcessInfoVo> ret = new ArrayList<ProcessInfoVo>(16);
        String database = StringUtils.isEmpty((String)db.getSysDBName()) ? "orcl" : db.getSysDBName();
        try (Connection conn = this.getConnection("jdbc:oracle:thin:@" + db.getAddress() + ":" + database, db);
             PreparedStatement preparedStatement = conn.prepareStatement(this.buildSql(db));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String sql = resultSet.getString("sql_text");
                if (!this.sqlFilter(sql)) continue;
                ret.add(this.convertValue(resultSet, db));
            }
        }
        catch (SQLException e) {
            log.error("Oracle query SQL snapshot error: ", (Throwable)e);
            if (e.getMessage().contains("denied")) {
                throw new KDException("Access denied");
            }
            if (e.getMessage().contains("ORA-00942")) {
                throw new KDException("No Permission");
            }
            throw new KDException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Oracle query SQL snapshot error: ", (Throwable)e);
            throw new KDException(e.getMessage());
        }
        return ret;
    }

    private String buildSql(ProcessExecParam db) {
        return "SELECT s.sid, s.serial#, s.username, s.event, s.status, s.osuser, s.machine, s.program, q.sql_text, q.parsing_schema_name, st.elapsed_time/1000 AS time FROM v$session s JOIN v$sql q ON s.sql_id = q.sql_id JOIN v$sqlstats st ON q.sql_id = st.sql_id WHERE s.status = 'ACTIVE' AND ROWNUM <= " + db.getLimit() + " AND st.elapsed_time/1000 >= " + db.getFilterTime() + " ORDER BY s.sid";
    }

    private ProcessInfoVo convertValue(ResultSet resultSet, ProcessExecParam db) throws SQLException {
        ArrayList<ProcessInfoVo.ActivityStat> result = new ArrayList<ProcessInfoVo.ActivityStat>();
        ProcessInfoVo vo = new ProcessInfoVo();
        result.add(new ProcessInfoVo.ActivityStat("sid", "id", resultSet.getInt("sid")));
        result.add(new ProcessInfoVo.ActivityStat("dbType", "dbType", "Oracle"));
        result.add(new ProcessInfoVo.ActivityStat("dbAddress", "dbAddress", db.getAddress()));
        result.add(new ProcessInfoVo.ActivityStat("sql_text", "sql", resultSet.getString("sql_text")));
        result.add(new ProcessInfoVo.ActivityStat("traceId", "traceId", this.parseTraceId(resultSet.getString("sql_text"))));
        result.add(new ProcessInfoVo.ActivityStat("parsing_schema_name", "schema", resultSet.getString("parsing_schema_name")));
        result.add(new ProcessInfoVo.ActivityStat("machine", "client", resultSet.getString("machine")));
        result.add(new ProcessInfoVo.ActivityStat("usename", "user", resultSet.getString("username")));
        result.add(new ProcessInfoVo.ActivityStat("event", "status", resultSet.getString("event")));
        result.add(new ProcessInfoVo.ActivityStat("serial#", "serial", resultSet.getString("serial#")));
        result.add(new ProcessInfoVo.ActivityStat("time", "useTime", resultSet.getInt("time")));
        vo.setResult(result);
        return vo;
    }
}

