/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.service.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.eye.api.dbmonitor.commons.JDBCConnectionHelper;
import kd.bos.eye.api.dbmonitor.entity.vo.KillSqlParam;
import kd.bos.eye.api.dbmonitor.service.SqlKiller;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OracleSqlKiller
implements SqlKiller,
JDBCConnectionHelper {
    private static final Log log = LogFactory.getLog(OracleSqlKiller.class);

    @Override
    public void kill(KillSqlParam db) {
        String database = StringUtils.isEmpty((String)db.getSysDBName()) ? "orcl" : db.getSysDBName();
        try (Connection conn = this.getConnection("jdbc:oracle:thin:@" + db.getAddress() + ":" + database, db);
             Statement stmt = conn.createStatement();){
            stmt.execute("ALTER SYSTEM KILL SESSION '" + db.getSid() + ", " + db.getSerial_() + "'");
        }
        catch (ClassNotFoundException | SQLException e) {
            log.error("Oracle kill query error: ", (Throwable)e);
            throw new KDException("kill query failed cause by: " + e.getMessage());
        }
    }
}

