/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter;

import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateRangeDao {
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(DateRangeDao.class);

    public String getStartRealTimeDate() {
        Integer days = Integer.getInteger("kdtx.task.expireTime", 15);
        return LocalDate.now().minusDays(days.intValue()).format(dateTimeFormatter);
    }

    private List<String> getStartArchiveDate0() {
        ArrayList<String> archiveDates = new ArrayList<String>();
        List allAccount = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : allAccount) {
            archiveDates.addAll(this.getStartArchiveDateByAccount(account));
        }
        return archiveDates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getStartArchiveDateByAccount(Account account) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql = "select min(farchive_date) as minArchiveDate from t_cbs_dtx_archive";
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
                ArrayList<String> archiveDateList = new ArrayList<String>();
                while (rs.next()) {
                    Date date = rs.getDate("minArchiveDate");
                    if (date != null) {
                        archiveDateList.add(date.toLocalDate().format(dateTimeFormatter));
                        continue;
                    }
                    archiveDateList.add(LocalDate.now().format(dateTimeFormatter));
                }
                return archiveDateList;
            });
            return list;
        }
        catch (Exception e) {
            logger.error("Getting archive min date by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getStartArchiveDate() {
        List startArchiveDates = ThreadPoolUtils.submit(this::getStartArchiveDate0);
        if (startArchiveDates == null || startArchiveDates.isEmpty()) {
            return null;
        }
        return (String)startArchiveDates.stream().min((o1, o2) -> {
            LocalDate date2;
            LocalDate date1 = LocalDate.parse(o1);
            if (date1.isEqual(date2 = LocalDate.parse(o2))) {
                return 0;
            }
            return date1.isBefore(date2) ? -1 : 1;
        }).get();
    }
}

