/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.LogInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class LogDao {
    private static final Log logger = LogFactory.getLog(LogDao.class);
    private static final int MAX_LOG_SIZE = 100;
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private List<LogInfo> getLogInfo0(ReporterSearchParam reporterSearchParam) {
        ArrayList<LogInfo> logInfos = new ArrayList<LogInfo>(10);
        List<Account> allAccount = new ArrayList();
        if (StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            if (StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
                Account account = new Account();
                account.setAccountId(reporterSearchParam.getAccountId());
                account.setTenantId(reporterSearchParam.getTenantId());
                allAccount.add(account);
            } else {
                allAccount = AccountUtils.getAllAccounts((String)reporterSearchParam.getTenantId());
            }
        } else {
            allAccount = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        for (Account account : allAccount) {
            logInfos.addAll(this.getLogInfoByAccount(account, reporterSearchParam));
        }
        return logInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<LogInfo> getLogInfoByAccount(Account account, ReporterSearchParam reporterSearchParam) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql = "select top 100\ntl.fxid as xid, \nts.fname as sceneName, \ntl.faction_type as actionType, \ntl.ftrigger_type as triggerType, \ntl.fresult as result, \ntl.fbranch_id as branchXid, \ntsb.fname as branchScene, \ntb.fresource as branchClazz, \ntl.fremark as remark, \ntl.fcreate_time as startTime, \ntl.fupdate_time as endTime, \ntl.ftraceid as traceId \nfrom \nt_cbs_dtx_logs tl \nleft join \nt_cbs_dtx_transaction as trs on trs.fxid = tl.fxid \nleft join \nt_cbs_dtx_tx_scenes as ts on ts.fid = trs.fscenes_tx_id \nleft join \nt_cbs_dtx_branch as tb on tb.fbranch_id = tl.fbranch_id \nleft join t_cbs_dtx_branch_scenes as tsb on tsb.fid = ts.fid \nwhere tl.fxid = ?\norder by tl.fcreate_time desc, tl.fid desc";
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{reporterSearchParam.getXid()}, rs -> {
                ArrayList<LogInfo> logInfos = new ArrayList<LogInfo>(10);
                while (rs.next()) {
                    LogInfo logInfo = new LogInfo();
                    logInfo.setXid(Long.toString(rs.getLong("xid")));
                    logInfo.setSceneName(rs.getString("sceneName"));
                    logInfo.setActionType(rs.getString("actionType"));
                    logInfo.setTriggerType(rs.getString("triggerType"));
                    logInfo.setResult(rs.getString("result"));
                    logInfo.setBranchXid(rs.getString("branchXid"));
                    logInfo.setBranchScene(rs.getString("branchScene"));
                    logInfo.setBranchClazz(rs.getString("branchClazz"));
                    logInfo.setTraceId(rs.getString("traceId"));
                    logInfo.setRemark(rs.getString("remark"));
                    Timestamp startTime = rs.getTimestamp("startTime");
                    Timestamp endTime = rs.getTimestamp("endTime");
                    String formatStartTime = startTime == null ? "" : startTime.toLocalDateTime().format(dateTimeFormatter);
                    String formatEndTime = endTime == null ? "" : endTime.toLocalDateTime().format(dateTimeFormatter);
                    logInfo.setStartTime(formatStartTime);
                    logInfo.setEndTime(formatEndTime);
                    logInfos.add(logInfo);
                }
                return logInfos;
            });
            return list;
        }
        catch (Exception e) {
            logger.error("Getting dtx scenes info by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<LogInfo> getLogInfos(ReporterSearchParam reporterSearchParam) {
        return ThreadPoolUtils.submit(() -> this.getLogInfo0(reporterSearchParam));
    }
}

