/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.NoSuccessInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.sql.CommonSQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class NoSuccessInfosDao {
    private static final Log logger = LogFactory.getLog(NoSuccessInfosDao.class);

    private List<NoSuccessInfo> getNoSuccessInfo0(ReporterSearchParam reporterSearchParam) {
        ArrayList<NoSuccessInfo> noSuccessInfos = new ArrayList<NoSuccessInfo>(10);
        List<Account> allAccount = new ArrayList();
        if (StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            if (StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
                Account account = new Account();
                account.setAccountId(reporterSearchParam.getAccountId());
                account.setTenantId(reporterSearchParam.getTenantId());
                allAccount.add(account);
            } else {
                allAccount = AccountUtils.getAllAccounts((String)reporterSearchParam.getTenantId());
            }
        } else {
            allAccount = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        for (Account account : allAccount) {
            noSuccessInfos.addAll(this.getNoSuccessByAccount(account, reporterSearchParam));
        }
        return noSuccessInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<NoSuccessInfo> getNoSuccessByAccount(Account account, ReporterSearchParam reporterSearchParam) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> sqlAndParams = this.chooseSqlByDataType(reporterSearchParam);
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)sqlAndParams.get("sql")), (Object[])((Object[])sqlAndParams.get("params")), rs -> {
                ArrayList<NoSuccessInfo> notRepairInfos = new ArrayList<NoSuccessInfo>(10);
                while (rs.next()) {
                    notRepairInfos.add(new NoSuccessInfo(Long.toString(rs.getLong("xid")), Integer.toString(rs.getInt("status")), rs.getString("sceneName")));
                }
                return notRepairInfos;
            });
            return list;
        }
        catch (Exception e) {
            logger.error("Getting dtx no sucess tx info by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Map<String, Object> chooseSqlByDataType(ReporterSearchParam reporterSearchParam) {
        String dataType;
        Map<String, Object> sqlAndParams = new HashMap<String, Object>(16);
        switch (dataType = reporterSearchParam.getDataType()) {
            case "exception": {
                sqlAndParams = CommonSQL.QUERY_EXCEPTION_INFO_SQL.getCompleteSql(reporterSearchParam);
                break;
            }
            case "rollback": {
                sqlAndParams = CommonSQL.QUERY_ROLLBACK_INFO_SQL.getCompleteSql(reporterSearchParam);
                break;
            }
            case "autoRepair": {
                sqlAndParams = CommonSQL.QUERY_AUTO_REPAIR_INFO_SQL.getCompleteSql(reporterSearchParam);
                break;
            }
            case "manualRepair": {
                sqlAndParams = CommonSQL.QUERY_MANUAL_REPAIR_INFO_SQL.getCompleteSql(reporterSearchParam);
                break;
            }
            case "notRepair": {
                sqlAndParams = CommonSQL.QUERY_NOT_REPAIR_INFO_SQL.getCompleteSql(reporterSearchParam);
            }
        }
        return sqlAndParams;
    }

    public List<NoSuccessInfo> getNoSuccessInfos(ReporterSearchParam reporterSearchParam) {
        return ThreadPoolUtils.submit(() -> this.getNoSuccessInfo0(reporterSearchParam));
    }
}

