/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.SceneInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangContext;

public class SceneInfosDao {
    private static final Log logger = LogFactory.getLog(SceneInfosDao.class);

    private List<SceneInfo> getScenesInfo0(Locale locale) {
        ArrayList<SceneInfo> sceneInfos = new ArrayList<SceneInfo>(10);
        List allAccount = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : allAccount) {
            sceneInfos.addAll(this.getScenesInfoByAccount(account, locale));
        }
        return sceneInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SceneInfo> getScenesInfoByAccount(Account account, Locale locale) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql = "select a.fid,a.fcode,case when b.fname is null then a.fname when b.fname = '' then a.fname when b.fname = ' ' then a.fname else b.fname end fname from t_cbs_dtx_tx_scenes a left join t_cbs_dtx_tx_scenes_l b on a.fid = b.fid and b.flocaleid =?";
            Object[] params = new Object[]{locale.toString()};
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, rs -> {
                ArrayList<SceneInfo> sceneInfoList = new ArrayList<SceneInfo>(10);
                while (rs.next()) {
                    SceneInfo sceneInfo = new SceneInfo();
                    sceneInfo.setId(rs.getString("fid"));
                    sceneInfo.setCode(rs.getString("fcode"));
                    sceneInfo.setName(rs.getString("fname"));
                    sceneInfoList.add(sceneInfo);
                }
                return sceneInfoList;
            });
            return list;
        }
        catch (Exception e) {
            logger.error("Getting dtx scenes info by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<SceneInfo> getScenesInfos() {
        final Locale locale = LangContext.getLocaleFromThreadTruck();
        List<SceneInfo> sceneInfos = ThreadPoolUtils.submit(new Callable<List<SceneInfo>>(){

            @Override
            public List<SceneInfo> call() throws Exception {
                return SceneInfosDao.this.getScenesInfo0(locale);
            }
        });
        if (sceneInfos == null || sceneInfos.isEmpty()) {
            return sceneInfos;
        }
        return sceneInfos.stream().distinct().collect(Collectors.toList());
    }
}

