/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.NoSuccessInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.sql.HistorySQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class HistoryNotRepairDao {
    private static final Log logger = LogFactory.getLog(HistoryNotRepairDao.class);

    public List<NoSuccessInfo> getNotRepairInfos(ReporterSearchParam reporterSearchParam) {
        return ThreadPoolUtils.submit(() -> this.getNotRepairInfos0(reporterSearchParam));
    }

    private List<NoSuccessInfo> getNotRepairInfos0(ReporterSearchParam reporterSearchParam) {
        List<NoSuccessInfo> notRepairInfos = new ArrayList<NoSuccessInfo>(10);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)reporterSearchParam.getTenantId());
            notRepairInfos = this.getNotRepairInfosByTenant(tenantInfo, reporterSearchParam);
            return notRepairInfos;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            notRepairInfos.addAll(this.getNotRepairInfosByTenant(tenantInfo, reporterSearchParam));
        }
        return notRepairInfos;
    }

    private List<NoSuccessInfo> getNotRepairInfosByTenant(TenantInfo tenantInfo, ReporterSearchParam reporterSearchParam) {
        ArrayList<NoSuccessInfo> notRepairInfos = new ArrayList<NoSuccessInfo>(10);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
            Account account = new Account();
            account.setAccountId(reporterSearchParam.getAccountId());
            account.setTenantId(reporterSearchParam.getTenantId());
            notRepairInfos.addAll(this.getNotRepairInfosByAccount(account, reporterSearchParam));
        }
        List allAccounts = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccounts) {
            notRepairInfos.addAll(this.getNotRepairInfosByAccount(account, reporterSearchParam));
        }
        return notRepairInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<NoSuccessInfo> getNotRepairInfosByAccount(Account account, ReporterSearchParam reporterSearchParam) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> notRepairSqlAndParams = HistorySQL.NOT_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            List list = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                ArrayList<NoSuccessInfo> notRepairInfos = new ArrayList<NoSuccessInfo>(10);
                while (rs.next()) {
                    notRepairInfos.add(new NoSuccessInfo(Long.toString(rs.getLong("xid")), Integer.toString(rs.getInt("status")), rs.getString("sceneName")));
                }
                return notRepairInfos;
            });
            return list;
        }
        catch (Exception e) {
            logger.error("Getting history not repaired transactions info by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

