/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.realtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.SceneViewInfo;
import kd.bos.eye.api.dtx.sql.SceneViewSQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class SceneViewDao {
    private static final Log logger = LogFactory.getLog(SceneViewDao.class);

    public Map<String, SceneViewInfo> getSceneViewInfos(ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        return ThreadPoolUtils.submit(() -> this.getSceneViewInfos0(reporterSearchParam, sceneViewInfoMap));
    }

    private Map<String, SceneViewInfo> getSceneViewInfos0(ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)reporterSearchParam.getTenantId());
            this.getSceneViewInfosByTenant(tenantInfo, reporterSearchParam, sceneViewInfoMap);
            return sceneViewInfoMap;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            this.getSceneViewInfosByTenant(tenantInfo, reporterSearchParam, sceneViewInfoMap);
        }
        return sceneViewInfoMap;
    }

    private void getSceneViewInfosByTenant(TenantInfo tenantInfo, ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
            Account account = new Account();
            account.setAccountId(reporterSearchParam.getAccountId());
            account.setTenantId(reporterSearchParam.getTenantId());
            this.getSceneViewInfosByAccount(account, reporterSearchParam, sceneViewInfoMap);
            return;
        }
        List allAccount = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccount) {
            this.getSceneViewInfosByAccount(account, reporterSearchParam, sceneViewInfoMap);
        }
    }

    private void getSceneViewInfosByAccount(Account account, ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> totalSqlAndParams = SceneViewSQL.QUERY_TOTAL_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)totalSqlAndParams.get("sql")), (Object[])((Object[])totalSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setTotal(rs.getInt("totals") + sceneViewInfo.getTotal());
                }
                return null;
            });
            Map<String, Object> successSqlAndParams = SceneViewSQL.QUERY_SUCCESS_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)successSqlAndParams.get("sql")), (Object[])((Object[])successSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setSuccess(rs.getInt("successes") + sceneViewInfo.getSuccess());
                }
                return null;
            });
            Map<String, Object> rollbackSqlAndParams = SceneViewSQL.QUERY_ROLLBACK_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)rollbackSqlAndParams.get("sql")), (Object[])((Object[])rollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setRollback(rs.getInt("rollbacks") + sceneViewInfo.getRollback());
                }
                return null;
            });
            Map<String, Object> exceptionSqlAndParams = SceneViewSQL.QUERY_EXCEPTION_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)exceptionSqlAndParams.get("sql")), (Object[])((Object[])exceptionSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setException(rs.getInt("exceptions") + sceneViewInfo.getException());
                }
                return null;
            });
            Map<String, Object> autoRepairSqlAndParams = SceneViewSQL.QUERY_AUTO_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)autoRepairSqlAndParams.get("sql")), (Object[])((Object[])autoRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setAutoRepair(rs.getInt("autoRepairs") + sceneViewInfo.getAutoRepair());
                }
                return null;
            });
            Map<String, Object> manualRepairSqlAndParams = SceneViewSQL.QUERY_MANUAL_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)manualRepairSqlAndParams.get("sql")), (Object[])((Object[])manualRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setManualRepair(rs.getInt("manualRepairs") + sceneViewInfo.getManualRepair());
                }
                return null;
            });
            Map<String, Object> notRepairSqlAndParams = SceneViewSQL.QUERY_NOT_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setNotRepair(rs.getInt("notRepairs") + sceneViewInfo.getNotRepair());
                }
                return null;
            });
            ReporterSearchParam reporterSearchParamTcc = ReporterSearchParam.copyFromReporterSearchParam(reporterSearchParam);
            reporterSearchParamTcc.setType(0);
            ArrayList tccScenes = new ArrayList();
            Map<String, Object> tccRollbackSqlAndParams = SceneViewSQL.QUERY_ROLLBACK_SQL.getCompleteSql(reporterSearchParamTcc);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)tccRollbackSqlAndParams.get("sql")), (Object[])((Object[])tccRollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    tccScenes.add(sceneId);
                }
                return null;
            });
            for (Map.Entry<String, SceneViewInfo> entry : sceneViewInfoMap.entrySet()) {
                SceneViewInfo sceneViewInfo = entry.getValue();
                if (tccScenes.contains(sceneViewInfo.getSceneId())) continue;
                sceneViewInfo.setTotal(sceneViewInfo.getTotal() - sceneViewInfo.getRollback());
                sceneViewInfo.setRollback(0);
            }
        }
        catch (Exception e) {
            logger.error("Getting dtx sceneView infos by account. Error: ", (Throwable)e);
        }
    }
}

