/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.CommonInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.TenantViewDetailInfo;
import kd.bos.eye.api.dtx.entity.reporter.TenantViewInfo;
import kd.bos.eye.api.dtx.sql.CommonSQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class TenantViewDao {
    private static final Log logger = LogFactory.getLog(TenantViewDao.class);

    public List<TenantViewDetailInfo> getTenantViewInfos(ReporterSearchParam reporterSearchParam) {
        return ThreadPoolUtils.submit(() -> this.getTenantViewInfos0(reporterSearchParam));
    }

    private List<TenantViewDetailInfo> getTenantViewInfos0(ReporterSearchParam reporterSearchParam) {
        ArrayList<TenantViewDetailInfo> tenantViewDetailInfos = new ArrayList<TenantViewDetailInfo>(10);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)reporterSearchParam.getTenantId());
            TenantViewDetailInfo tenantViewDetailInfo = new TenantViewDetailInfo(tenantInfo.getId(), tenantInfo.getName(), this.getTenantViewInfosByTenant(tenantInfo, reporterSearchParam));
            tenantViewDetailInfos.add(tenantViewDetailInfo);
            return tenantViewDetailInfos;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            TenantViewDetailInfo tenantViewDetailInfo = new TenantViewDetailInfo(tenantInfo.getId(), tenantInfo.getName(), this.getTenantViewInfosByTenant(tenantInfo, reporterSearchParam));
            tenantViewDetailInfos.add(tenantViewDetailInfo);
        }
        return tenantViewDetailInfos;
    }

    private Map<String, CommonInfo> getTenantViewInfosByTenant(TenantInfo tenantInfo, ReporterSearchParam reporterSearchParam) {
        HashMap<String, CommonInfo> totalResultMap = new HashMap<String, CommonInfo>(16);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
            Account account = new Account();
            account.setAccountId(reporterSearchParam.getAccountId());
            account.setTenantId(reporterSearchParam.getTenantId());
            totalResultMap.put(reporterSearchParam.getAccountId(), this.getTenantViewInfosByAccount(account, reporterSearchParam));
            return totalResultMap;
        }
        List allAccount = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccount) {
            totalResultMap.put(account.getAccountId(), this.getTenantViewInfosByAccount(account, reporterSearchParam));
        }
        return totalResultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommonInfo getTenantViewInfosByAccount(Account account, ReporterSearchParam reporterSearchParam) {
        CommonInfo commonInfo2 = new CommonInfo();
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> totalSqlAndParams = CommonSQL.QUERY_TOTAL_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)totalSqlAndParams.get("sql")), (Object[])((Object[])totalSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setTotal(rs.getInt("totals"));
                }
                return null;
            });
            Map<String, Object> successSqlAndParams = CommonSQL.QUERY_SUCCESS_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)successSqlAndParams.get("sql")), (Object[])((Object[])successSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setSuccess(rs.getInt("successes"));
                }
                return null;
            });
            Map<String, Object> rollbackSqlAndParams = CommonSQL.QUERY_ROLLBACK_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)rollbackSqlAndParams.get("sql")), (Object[])((Object[])rollbackSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setRollback(rs.getInt("rollbacks"));
                }
                return null;
            });
            Map<String, Object> exceptionSqlAndParams = CommonSQL.QUERY_EXCEPTION_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)exceptionSqlAndParams.get("sql")), (Object[])((Object[])exceptionSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setException(rs.getInt("exceptions"));
                }
                return null;
            });
            Map<String, Object> autoRepairSqlAndParams = CommonSQL.QUERY_AUTO_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)autoRepairSqlAndParams.get("sql")), (Object[])((Object[])autoRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setAutoRepair(rs.getInt("autoRepairs"));
                }
                return null;
            });
            Map<String, Object> manualRepairSqlAndParams = CommonSQL.QUERY_MANUAL_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)manualRepairSqlAndParams.get("sql")), (Object[])((Object[])manualRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setManualRepair(rs.getInt("manualRepairs"));
                }
                return null;
            });
            Map<String, Object> notRepairSqlAndParams = CommonSQL.QUERY_NOT_REPAIR_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)notRepairSqlAndParams.get("sql")), (Object[])((Object[])notRepairSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
            if (reporterSearchParam != null) {
                if (reporterSearchParam.getType() == null) {
                    ReporterSearchParam reporterSearchParamTcc = ReporterSearchParam.copyFromReporterSearchParam(reporterSearchParam);
                    reporterSearchParamTcc.setType(0);
                    Map<String, Object> sqlAndParams = CommonSQL.QUERY_ROLLBACK_SQL.getCompleteSql(reporterSearchParamTcc);
                    int rollback = (Integer)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)sqlAndParams.get("sql")), (Object[])((Object[])sqlAndParams.get("params")), rs -> {
                        if (rs.next()) {
                            return rs.getInt("rollbacks");
                        }
                        return 0;
                    });
                    commonInfo2.setTotal(commonInfo2.getTotal() - (commonInfo2.getRollback() - rollback));
                    commonInfo2.setRollback(rollback);
                } else if (reporterSearchParam.getType() == 1 || reporterSearchParam.getType() == 2) {
                    commonInfo2.setTotal(commonInfo2.getTotal() - commonInfo2.getRollback());
                    commonInfo2.setRollback(0);
                }
            }
            CommonInfo commonInfo = commonInfo2;
            return commonInfo;
        }
        catch (Exception e) {
            logger.error("Getting dtx tenant view infos by account. Error: ", (Throwable)e);
            return null;
        }
    }

    public List<TenantViewInfo> translate(List<TenantViewDetailInfo> tenantViewDetailInfos) {
        ArrayList<TenantViewInfo> tenantViewInfos = new ArrayList<TenantViewInfo>(10);
        for (TenantViewDetailInfo tenantViewDetailInfo : tenantViewDetailInfos) {
            TenantViewInfo tenantViewInfo = new TenantViewInfo();
            tenantViewInfo.setTenantId(tenantViewDetailInfo.getTenantId());
            this.totalAccountResult(tenantViewDetailInfo.getResultMap(), tenantViewInfo);
            tenantViewInfos.add(tenantViewInfo);
        }
        return tenantViewInfos;
    }

    private void totalAccountResult(Map<String, CommonInfo> resultMap, TenantViewInfo tenantViewInfo) {
        int total = 0;
        int success = 0;
        int rollback = 0;
        int exception = 0;
        int autoRepair = 0;
        int manualRepair = 0;
        int notRepair = 0;
        for (CommonInfo commonInfo : resultMap.values()) {
            if (commonInfo == null) continue;
            total += commonInfo.getTotal().intValue();
            success += commonInfo.getSuccess().intValue();
            rollback += commonInfo.getRollback().intValue();
            exception += commonInfo.getException().intValue();
            autoRepair += commonInfo.getAutoRepair().intValue();
            manualRepair += commonInfo.getManualRepair().intValue();
            notRepair += commonInfo.getNotRepair().intValue();
        }
        tenantViewInfo.setMultiField(total, success, rollback, exception, autoRepair, manualRepair, notRepair);
    }
}

