/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import kd.bos.eye.api.dtx.dao.reporter.DateRangeDao;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.JSONUtils;

public class DateRangeHandler
extends AbstractHttpHandler {
    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        DateRangeDao dateRangeDao = new DateRangeDao();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            ReporterSearchParam reporterSearchParam = ExchangeVueUtils.parseJsonFromPost(exchange, ReporterSearchParam.class);
            if (reporterSearchParam == null || "realTime".equals(reporterSearchParam.getReporterType())) {
                String startRealTimeDate = dateRangeDao.getStartRealTimeDate();
                dataMap.put("startDate", startRealTimeDate);
                dataMap.put("endDate", LocalDate.now().format(DateRangeDao.dateTimeFormatter));
            } else {
                String startArchiveDate = dateRangeDao.getStartArchiveDate();
                dataMap.put("startDate", startArchiveDate);
                dataMap.put("endDate", LocalDate.now().minusDays(1L).format(DateRangeDao.dateTimeFormatter));
            }
            response.put("code", 0);
            response.put("data", dataMap);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

