/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.service.reporter.history;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.dtx.dao.reporter.SceneInfosDao;
import kd.bos.eye.api.dtx.dao.reporter.history.HistorySceneViewDao;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.SceneInfo;
import kd.bos.eye.api.dtx.entity.reporter.SceneViewInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.JSONUtils;

public class HistorySceneViewHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        HashMap<String, List<SceneViewInfo>> sceneViewDataMap = new HashMap<String, List<SceneViewInfo>>();
        HistorySceneViewDao historySceneViewDao = new HistorySceneViewDao();
        try {
            ReporterSearchParam reporterSearchParam = ExchangeVueUtils.parseJsonFromPost(exchange, ReporterSearchParam.class);
            Map<String, SceneViewInfo> sceneViewInfoMap = this.getAllSceneViewInfos();
            Map<String, SceneViewInfo> historySceneViewInfoMap = historySceneViewDao.getHistorySceneViewInfos(reporterSearchParam, sceneViewInfoMap);
            sceneViewDataMap.put("sceneViewInfos", this.translateAndSort(historySceneViewInfoMap));
            response.put("code", 0);
            response.put("data", sceneViewDataMap);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private Map<String, SceneViewInfo> getAllSceneViewInfos() {
        HashMap<String, SceneViewInfo> sceneViewInfoMap = new HashMap<String, SceneViewInfo>(16);
        SceneInfosDao sceneInfosDao = new SceneInfosDao();
        List<SceneInfo> sceneInfos = sceneInfosDao.getScenesInfos();
        for (SceneInfo sceneInfo : sceneInfos) {
            sceneViewInfoMap.put(sceneInfo.getId(), new SceneViewInfo(sceneInfo.getId(), sceneInfo.getCode(), sceneInfo.getName()));
        }
        return sceneViewInfoMap;
    }

    private List<SceneViewInfo> translateAndSort(Map<String, SceneViewInfo> sceneViewInfoMap) {
        ArrayList<SceneViewInfo> sceneViewInfos = new ArrayList<SceneViewInfo>(sceneViewInfoMap.values());
        return sceneViewInfos.stream().filter(sceneViewInfo -> sceneViewInfo.getTotal() != 0).sorted(Comparator.comparingInt(SceneViewInfo::getTotal).reversed()).collect(Collectors.toList());
    }
}

