/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.eventdata;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.StorageType;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.EventTypeManager;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class EventDataHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(EventDataHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map<String, String> params = this.getParams(exchange, false);
            String startDate = params.get("startDate");
            String endDate = params.get("endDate");
            Date start = dateFormat.parse(startDate);
            Date end = endDate != null ? dateFormat.parse(endDate) : new Date();
            List eventDataList = storage.eventData(start, end, params);
            List eventTypeList = EventTypeManager.getAllFirstEventType();
            List<Map<String, Object>> eventTypeMapList = this.convertEventTypesToMaps(eventTypeList);
            HashMap<String, List<Map<String, Object>>> retMap = new HashMap<String, List<Map<String, Object>>>(2);
            retMap.put("eventDataList", eventDataList);
            retMap.put("eventTypeList", eventTypeMapList);
            response.setCode(0);
            response.setData(retMap);
        }
        catch (Exception e) {
            logger.error("EventDataException\uff1a", (Throwable)e);
            response.setCode(-1);
            response.setMsg("EventDataException\uff1a" + e);
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<Map<String, Object>> convertEventTypesToMaps(List<EventType> eventTypes) {
        ArrayList<Map<String, Object>> eventTypeMapList = new ArrayList<Map<String, Object>>(eventTypes.size());
        for (EventType eventType : eventTypes) {
            HashMap<String, Object> eventTypeMap = new HashMap<String, Object>();
            eventTypeMap.put("parentName", eventType.getParentName());
            eventTypeMap.put("name", eventType.getName());
            String key = eventType.getName();
            String def = eventType.getDesc();
            String desc = LangRes.apm.getString(key, def, new Object[0]);
            eventTypeMap.put("desc", desc);
            List subTypes = eventType.getSubTypes();
            if (subTypes != null) {
                List<Map<String, Object>> subTypesMaps = this.convertEventTypesToMaps(subTypes);
                eventTypeMap.put("subTypes", subTypesMaps);
            } else {
                eventTypeMap.put("subTypes", null);
            }
            eventTypeMapList.add(eventTypeMap);
        }
        return eventTypeMapList;
    }
}

