/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.filemanager.CryptFileRestorer;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class CryptFileRepairHandler
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final String defaultStartTime = "2024-11-06 00:00:00";
    private static final String defaultEndTime = "2024-11-09 03:00:00";
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String TENANT = "tenant";
    private static final String DOREPAIR = "dorepair";
    private static final String MATCHACCOUNT = "matchaccount";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final CryptFileRepairHandler instance = new CryptFileRepairHandler();

    @Override
    public String[] getPaths() {
        return new String[]{"/eye/fileRepair/", "/eye/fileRepair"};
    }

    @Override
    public HttpHandler getHandler() {
        return instance;
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        Thread.currentThread().setName("Thread-CryptFileRepairHandler");
        ApiResponse response = new ApiResponse();
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getQuery());
        String tenant = params.get(TENANT);
        boolean doRepair = Boolean.parseBoolean(params.get(DOREPAIR));
        boolean matchAccount = Boolean.parseBoolean(params.get(MATCHACCOUNT));
        String startTimeStr = params.get(STARTTIME);
        String endTimeStr = params.get(ENDTIME);
        startTimeStr = StringUtils.isEmpty((String)startTimeStr) ? defaultStartTime : startTimeStr;
        String string = endTimeStr = StringUtils.isEmpty((String)endTimeStr) ? defaultEndTime : endTimeStr;
        if (StringUtils.isEmpty((String)tenant)) {
            response.setMsg("The param of tenants is required");
            String str = JSONUtils.toString(response);
            this.writeJson(str, exchange);
            return;
        }
        String resMsg = "";
        try {
            resMsg = CryptFileRestorer.repairCryptFile(tenant, doRepair, OPLOGGER, exchange, startTimeStr, endTimeStr, matchAccount);
        }
        catch (ParseException e) {
            response.setCode(-1);
            response.setMsg("\u4fee\u590d\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
            String str = JSONUtils.toString(response);
            this.writeJson(str, exchange);
            return;
        }
        response.setMsg(resMsg);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

