/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.filemanager.FileDecodeUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.impl.AbstractFileService;
import kd.bos.fileservice.impl.AttachmentFileService;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternal
class CryptFileRestorer {
    private static final Logger logger = LoggerFactory.getLogger(CryptFileRestorer.class);
    private static final List<RequestContext> rcList = new CopyOnWriteArrayList<RequestContext>();
    private static final Set<String> tenantSet = new HashSet<String>();
    private static final Map<String, String> tenantAccountMap = new HashMap<String, String>();
    private static final ThreadPool FILEREPAIR_EXECUTOR = ThreadPools.newFixedThreadPool((String)"Monitor-filerepair", (int)1);

    CryptFileRestorer() {
    }

    public static String repairCryptFile(String tenant, boolean doRepair, OpLogger OPLOGGER, HttpExchange exchange, String starttime, String endtime, boolean matchAccount) throws ParseException {
        StringBuilder res = new StringBuilder("");
        logger.info("FileRepair " + new Date() + "\u5f00\u59cb\u6267\u884crepair\u903b\u8f91\uff0ctenants\uff1a " + tenant);
        res.append("<br>").append(new Date()).append("\u5f00\u59cb\u6267\u884crepair\u903b\u8f91\uff0ctenants\uff1a").append(tenant).append("<br><br>");
        if (!tenantSet.contains(tenant)) {
            logger.info("FileRepair \u6ca1\u6709\u79df\u6237\uff1a" + tenant + "\u7684\u4fe1\u606f");
            res.append("\u6ca1\u6709\u79df\u6237\uff1a").append(tenant).append("\u7684\u4fe1\u606f<br><br>");
            return res.toString();
        }
        int bufferSize = Integer.parseInt(System.getProperty("filepreview.bufferSize", "8"));
        AbstractFileService fileService = new AbstractFileService("attachmentServer.url", "yunpan.previewUrl", AttachmentFileService.getUploadTimeout(), AttachmentFileService.isPreviewcacheEnable(), bufferSize){

            public int getMaxUploadSize() {
                return Integer.parseInt(System.getProperty("attachmentServer.maxFileSize", "52428800"));
            }
        };
        for (RequestContext rc : rcList) {
            if (!rc.getTenantId().equals(tenant) || !rc.getAccountId().equals(tenantAccountMap.get(tenant)) && matchAccount) continue;
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a%s\u7684repair\u6d41\u7a0b\u5f00\u59cb=========================================================", rc.getTenantId(), rc.getAccountId()));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a%s\u7684repair\u6d41\u7a0b\u5f00\u59cb==========================================================", rc.getTenantId(), rc.getAccountId())).append("<br>");
            RequestContext.copyAndSet((RequestContext)rc);
            Set filePaths = CryptFileRestorer.submit(() -> CryptFileRestorer.queryFilePath(starttime, endtime));
            if (filePaths == null) {
                logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cqueryFilePath \u7ed3\u679c\u4e3a\u7a7a\uff0crepair\u6d41\u7a0b\u7ed3\u675f=========================================================", rc.getTenantId()));
                res.append(String.format("\u79df\u6237\uff1a%s\uff0cqueryFilePath \u7ed3\u679c\u4e3a\u7a7a\uff0crepair\u6d41\u7a0b\u7ed3\u675f=========================================================", rc.getTenantId())).append("<br><br><br>");
                continue;
            }
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c%s\u5230%s\u671f\u95f4\uff0c\u603b\u6570\uff1a%s", rc.getTenantId(), starttime, endtime, filePaths.size()));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0c%s\u5230%s\u671f\u95f4\uff0c\u603b\u6570\uff1a%s", rc.getTenantId(), starttime, endtime, filePaths.size())).append("<br>");
            if (filePaths.size() == 0) {
                logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c\u671f\u95f4\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff0crepair\u6d41\u7a0b\u7ed3\u675f=========================================================", rc.getTenantId()));
                res.append(String.format("\u79df\u6237\uff1a%s\uff0c\u671f\u95f4\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff0crepair\u6d41\u7a0b\u7ed3\u675f==========================================================", rc.getTenantId())).append("<br><br><br>");
                continue;
            }
            List<String> cryptFiles = CryptFileRestorer.getCryptFilePaths(filePaths, (FileService)fileService, rc, res);
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cdecode\u5206\u6790\u5b8c\u6210\uff0c\u603b\u6570\uff1a%s\u4e2a\uff0cencode\u5171\uff1a%s\u4e2a", rc.getTenantId(), filePaths.size(), cryptFiles.size()));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0cdecode\u5206\u6790\u5b8c\u6210\uff0c\u603b\u6570\uff1a%s\u4e2a\uff0cencode\u5171\uff1a%s\u4e2a", rc.getTenantId(), filePaths.size(), cryptFiles.size())).append("<br>");
            for (int i = 0; i < cryptFiles.size(); ++i) {
                logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cencode\u6587\u4ef6%s/%s\uff1a\n%s", rc.getTenantId(), i + 1, cryptFiles.size(), cryptFiles.get(i)));
                res.append(String.format("\u79df\u6237\uff1a%s\uff0cencode\u6587\u4ef6%s/%s\uff1a<br>%s", rc.getTenantId(), i + 1, cryptFiles.size(), cryptFiles.get(i))).append("<br>");
            }
            if (!doRepair) {
                res.append(String.format("\u79df\u6237\uff1a%s\uff0crepair\u6d41\u7a0b\u7ed3\u675f==========================================================", rc.getTenantId())).append("<br><br><br>");
                continue;
            }
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c\u5f00\u59cbbak&cover\u6d41\u7a0b", rc.getTenantId()));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0c\u5f00\u59cbbak&cover\u6d41\u7a0b", rc.getTenantId())).append("<br>");
            long doDakFailedCount = 0L;
            long doCoverFailedCount = 0L;
            for (String path : cryptFiles) {
                if (!fileService.exists(path)) continue;
                try {
                    CryptFileRestorer.doBak((FileService)fileService, path, rc);
                    logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cbak success\uff1a%s", rc.getTenantId(), path));
                    res.append(String.format("\u79df\u6237\uff1a%s\uff0cdocover success\uff1a<br>%s", rc.getTenantId(), path)).append("<br>");
                    OPLOGGER.opLog(exchange, OpType.ADD, path, String.format("\u79df\u6237\uff1a%s\uff0cbak\u6210\u529f\uff1a%s", rc.getTenantId(), path));
                }
                catch (Exception e) {
                    ++doDakFailedCount;
                    logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cbak\uff1a%s\uff0cfailed\uff1a%s", rc.getTenantId(), path, e.getMessage()));
                    res.append(String.format("\u79df\u6237\uff1a%s\uff0cbak\uff1a%s\uff0cfailed\uff1a%s", rc.getTenantId(), path, e.getMessage())).append("<br>");
                    continue;
                }
                try {
                    CryptFileRestorer.doCover((FileService)fileService, path, rc);
                    logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cdocover success\uff1a%s", rc.getTenantId(), path));
                    res.append(String.format("\u79df\u6237\uff1a%s\uff0cdocover success\uff1a<br>%s", rc.getTenantId(), path)).append("<br>");
                    OPLOGGER.opLog(exchange, OpType.EXECUTE, path, String.format("\u79df\u6237\uff1a%s\uff0cdocover success\uff1a%s", rc.getTenantId(), path));
                }
                catch (Exception e) {
                    ++doCoverFailedCount;
                    logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0ccover\uff1a%s\uff0cfailed\uff1a%s", rc.getTenantId(), path, e.getMessage()));
                    res.append(String.format("\u79df\u6237\uff1a%s\uff0ccover\uff1a%s\uff0cfailed\uff1a%s", rc.getTenantId(), path, e.getMessage())).append("<br>");
                }
            }
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0cfile need repaired\uff1a%s\uff0crepair success\uff1a%s\uff0cbak field\uff1a%s\uff0ccover failed\uff1a%s", rc.getTenantId(), cryptFiles.size(), (long)cryptFiles.size() - doDakFailedCount - doCoverFailedCount, doDakFailedCount, doCoverFailedCount));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0cfile need repaired\uff1a%s\uff0crepair success\uff1a%s\uff0cbak field\uff1a%s\uff0ccover failed\uff1a%s", rc.getTenantId(), cryptFiles.size(), (long)cryptFiles.size() - doDakFailedCount - doCoverFailedCount, doDakFailedCount, doCoverFailedCount)).append("<br>");
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c\u6240\u6709\u6d41\u7a0b\u7ed3\u675f=========================================================", rc.getTenantId()));
            res.append(String.format("\u79df\u6237\uff1a%s\uff0crepair\u6d41\u7a0b\u7ed3\u675f==========================================================", rc.getTenantId())).append("<br><br><br>");
        }
        logger.info("FileRepair " + new Date() + "\u6574\u4e2a\u6d41\u7a0b\u6267\u884c\u5b8c\u6210\uff0ctenant\uff1a " + tenant);
        res.append(new Date()).append("\u6574\u4e2a\u6d41\u7a0b\u6267\u884c\u5b8c\u6210<br>");
        return res.toString();
    }

    private static Set<String> queryFilePath(String starttime, String endtime) throws ParseException {
        Date endTime;
        Date startTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            startTime = sdf.parse(starttime);
            endTime = sdf.parse(endtime);
        }
        catch (ParseException e) {
            logger.info("FileRepair \u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            throw e;
        }
        HashSet<String> filePaths = new HashSet<String>();
        String querybas = "select ffileid, fcreatetime from t_bas_attachment where fcreatetime >= ? AND fcreatetime <= ?";
        DB.query((DBRoute)DBRoute.base, (String)querybas, (Object[])new Object[]{startTime, endTime}, resultSet -> {
            while (resultSet.next()) {
                filePaths.add(resultSet.getString("ffileid"));
            }
            return null;
        });
        String querysvc = "select fpath, fcreatetime from t_svc_attachment where fcreatetime >= ? AND fcreatetime <= ?";
        DB.query((DBRoute)DBRoute.base, (String)querysvc, (Object[])new Object[]{startTime, endTime}, resultSet -> {
            while (resultSet.next()) {
                filePaths.add(resultSet.getString("fpath"));
            }
            return null;
        });
        String querybd = "select furl, fcreatetime from t_bd_attachment where fcreatetime >= ? AND fcreatetime <= ?";
        DB.query((DBRoute)DBRoute.base, (String)querybd, (Object[])new Object[]{startTime, endTime}, resultSet -> {
            while (resultSet.next()) {
                filePaths.add(resultSet.getString("furl"));
            }
            return null;
        });
        return filePaths;
    }

    private static List<String> getCryptFilePaths(Set<String> files, FileService fileService, RequestContext rc, StringBuilder res) {
        ArrayList<String> cryptFiles = new ArrayList<String>();
        for (String file : files) {
            if (fileService.exists(file)) {
                try {
                    InputStream inputStream = fileService.getInputStream(file);
                    Throwable throwable = null;
                    try {
                        InputStream ignored = FileDecodeUtil.decode(inputStream);
                        Throwable throwable2 = null;
                        try {
                            cryptFiles.add(file);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ignored.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    logger.info("FileRepair " + String.format("decode\u51fa\u9519\uff1a%s\uff0c\u56e0\u4e3a\uff1a%s", file, e.getMessage()));
                }
                continue;
            }
            logger.info("FileRepair \u6587\u4ef6\u4e0d\u5b58\u5728\uff1a " + file);
        }
        return cryptFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doBak(FileService fileService, String path, RequestContext rc) throws IOException {
        Path tempFilePath = null;
        InputStream bakInputStream = null;
        try (InputStream cryptFileIS = fileService.getInputStream(path);){
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            String pathPrefix = path.substring(0, path.lastIndexOf("/"));
            String bakFileFullPath = pathPrefix + "/bak/" + fileName;
            tempFilePath = CryptFileRestorer.getTempBin(cryptFileIS, path);
            bakInputStream = Files.newInputStream(tempFilePath.toFile().toPath(), new OpenOption[0]);
            FileItem fileItem = new FileItem(fileName, bakFileFullPath, bakInputStream);
            fileItem.setCreateNewFileWhenExists(false);
            String upload = fileService.upload(fileItem);
            logger.info("FileRepair " + String.format("\u79df\u6237\uff1a%s\uff0c\u5907\u4efd\u6587\u4ef6\uff1a%s\uff0c\u5907\u4efd\u6210\u529f\uff0c\u4e0a\u4f20\u7ed3\u679c\uff1a%s", rc.getTenantId(), path, upload));
        }
        finally {
            if (tempFilePath != null && tempFilePath.toFile().exists()) {
                tempFilePath.toFile().delete();
            }
            if (bakInputStream != null) {
                try {
                    bakInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCover(FileService fileService, String path, RequestContext rc) throws IOException {
        Path tempFilePath = null;
        InputStream bakInputStream = null;
        try (InputStream cryptFileIS = fileService.getInputStream(path);){
            String fileName = path.substring(path.lastIndexOf("/"));
            tempFilePath = CryptFileRestorer.getTempBin(cryptFileIS, path);
            bakInputStream = Files.newInputStream(tempFilePath.toFile().toPath(), new OpenOption[0]);
            InputStream decode = FileDecodeUtil.decode(bakInputStream);
            FileItem fileItem = new FileItem(fileName, path, decode);
            fileItem.setCreateNewFileWhenExists(false);
            fileService.upload(fileItem);
        }
        finally {
            if (tempFilePath != null && tempFilePath.toFile().exists()) {
                tempFilePath.toFile().delete();
            }
            if (bakInputStream != null) {
                try {
                    bakInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Path getTempBin(InputStream inputStream, String originFileName) throws IOException {
        String fileExtension = originFileName.substring(originFileName.lastIndexOf("."));
        String tempFileName = "tempfile-" + System.currentTimeMillis();
        Path path = Files.createTempFile(tempFileName, fileExtension, new FileAttribute[0]);
        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        IOUtils.closeQuietly((InputStream)inputStream);
        return path;
    }

    public static <T> T submit(Callable<T> callable) {
        Future future = FILEREPAIR_EXECUTOR.submit(callable);
        while (!future.isDone()) {
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.info("getting dtx scenes info in future. Error: ", (Throwable)e);
            return null;
        }
    }

    static {
        List allAccounts = new ArrayList();
        try {
            allAccounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception e) {
            logger.info("FileRepair FileRepair GetAllAccountsOfCurrentEnv failed\uff1a " + e.getMessage(), (Throwable)e);
        }
        for (Account account : allAccounts) {
            RequestContext rc = RequestContext.create((boolean)false);
            rc.setAccountId(account.getAccountId());
            rc.setTenantId(account.getTenantId());
            rcList.add(rc);
            tenantSet.add(account.getTenantId());
        }
        tenantAccountMap.put("cjic", "1763822851577728000");
        tenantAccountMap.put("guocoland", "1215882265972725760");
        tenantAccountMap.put("gzjk", "1888529424589004800");
        tenantAccountMap.put("hnscg", "1790749975286764544");
        tenantAccountMap.put("jiaherb", "1636245944129300480");
        tenantAccountMap.put("linton", "1245426648187166720");
        tenantAccountMap.put("mpfp", "1767469911430425600");
        tenantAccountMap.put("success", "1671153665160794112");
        tenantAccountMap.put("wanfu", "1717407459900932096");
        tenantAccountMap.put("wisontax", "1827598704824028160");
        tenantAccountMap.put("wtjt", "1513072754872583168");
        tenantAccountMap.put("xjhtrq", "1808867112618392576");
        tenantAccountMap.put("zhaojinmotian", "1803027991526113280");
        tenantAccountMap.put("zhengtongauto", "1452152754708422656");
        tenantAccountMap.put("zqyl", "1692170691270530048");
        tenantAccountMap.put("tenant_devcorelib_dev", "1307271305870966784");
    }
}

