/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
class FileDecodeUtil {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static String DEVFLAG = "pqk1_";
    private static final String fileservice_ext_code = System.getProperty("fileservice.ext.code", "QVb2aLsx2zoX9NG5FCTvDUF60fNdBVrOrr2NoPakS34");
    private static final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Log logger = LogFactory.getLog(FileDecodeUtil.class);
    private static final SecretKey secretKey = new SecretKeySpec(Base64.getDecoder().decode(fileservice_ext_code), "AES");

    FileDecodeUtil() {
    }

    public static InputStream encode(String originalPath, InputStream in) {
        logger.info("FileRepair \u5f00\u59cb\u6587\u4ef6encode=======================");
        Cipher cipher = null;
        InputStream returnInputStream = in;
        ByteArrayOutputStream outputStream = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            outputStream = FileDecodeUtil.convertToByteArray(in);
            byte[] encryptedBytes = cipher.doFinal(outputStream.toByteArray());
            returnInputStream = new ByteArrayInputStream(encryptedBytes);
            return returnInputStream;
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.info("FileRepair \u6587\u4ef6encode\u62a5\u9519\uff1a", (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.info("FileRepair \u6587\u4ef6encode\u62a5\u9519\uff1a", (Object)e);
                    throw new RuntimeException(e);
                }
            }
            if (returnInputStream != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.info("FileRepair \u6587\u4ef6encode\u62a5\u9519\uff1a", (Object)e);
                    throw new RuntimeException(e);
                }
                return returnInputStream;
            }
            return in;
        }
    }

    public static InputStream decode(InputStream in) {
        logger.info("FileRepair \u5f00\u59cb\u6587\u4ef6decode=======================");
        ByteArrayInputStream returnInputStream = null;
        ByteArrayInputStream inputStreamBak = null;
        ByteArrayOutputStream outputStream = null;
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            outputStream = FileDecodeUtil.convertToByteArray(in);
            inputStreamBak = new ByteArrayInputStream(outputStream.toByteArray());
            byte[] encryptedBytes = cipher.doFinal(outputStream.toByteArray());
            returnInputStream = new ByteArrayInputStream(encryptedBytes);
        }
        catch (Throwable e) {
            logger.info("FileRepair \u6587\u4ef6decode\u62a5\u9519\uff1a", (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.info("FileRepair \u6587\u4ef6decode\u62a5\u9519\uff1a", (Object)e);
                    throw new RuntimeException(e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.info("FileRepair \u6587\u4ef6decode\u62a5\u9519\uff1a", (Object)e);
                    throw new RuntimeException(e);
                }
            }
        }
        if (returnInputStream != null) {
            try {
                ((InputStream)inputStreamBak).close();
            }
            catch (IOException e) {
                logger.info("FileRepair \u6587\u4ef6decode\u62a5\u9519\uff1a", (Object)e);
                throw new RuntimeException(e);
            }
            return returnInputStream;
        }
        return inputStreamBak;
    }

    public static ByteArrayOutputStream convertToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream;
    }
}

