/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.AlarmConfigHandler;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.manage.DiskUrlInfo;
import kd.bos.fileservice.manage.FileMsgInfo;
import kd.bos.fileservice.manage.FileServerManage;
import kd.bos.fileservice.manage.FileServerManageFactory;
import kd.bos.fileservice.manage.FileServerMsgInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class FileServiceMonitorHandler
extends AbstractHttpHandler {
    private static final String PLACEHOLDER = "/server/";
    private static final Log log = LogFactory.getLog(AlarmConfigHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> dataMap;
        ApiResponse response;
        block37: {
            response = new ApiResponse();
            dataMap = new HashMap<String, Object>(4);
            response.setCode(0);
            try {
                URI uri = exchange.getRequestURI();
                String reqPath = uri.getPath();
                int pos = reqPath.indexOf(PLACEHOLDER);
                String actionType = reqPath.substring(pos + PLACEHOLDER.length());
                FileServerManage fileServerManage = FileServerManageFactory.getAttachmentFileServerManage();
                if ("getFileServerMsgInfo".equals(actionType)) {
                    FileServerMsgInfo fileServerMsgInfo = fileServerManage.getFileServerMsgInfo();
                    dataMap.put("isAvailable", fileServerMsgInfo.isAvailable());
                    dataMap.put("msg", FileServiceMonitorHandler.getLangStr(fileServerMsgInfo.getAvailableMsg()));
                    dataMap.put("version", fileServerMsgInfo.getFileServiceVersion().toString());
                    dataMap.put("maxDirectoryScanDepth", fileServerMsgInfo.getMaxDirectoryScanDepth());
                    break block37;
                }
                if ("getDiskUrlInfoList".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    List diskUrlInfoList = fileServerManage.getDiskUrlInfoList("true".equals(params.get("withSpaceMsg")));
                    for (DiskUrlInfo diskUrlInfo : diskUrlInfoList) {
                        diskUrlInfo.setMsg(FileServiceMonitorHandler.getLangStr(diskUrlInfo.getMsg()));
                    }
                    dataMap.put("diskUrlInfos", diskUrlInfoList);
                    break block37;
                }
                if ("getFileMsgTreeTableData".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    String diskUrl = params.get("diskUrl");
                    String depthStr = params.get("depth");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)diskUrl) || org.apache.commons.lang.StringUtils.isEmpty((String)depthStr)) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'diskUrl'/'depth' can not be null!"});
                    }
                    int depth = Integer.parseInt(depthStr);
                    String fileMsgTreeJsonData = fileServerManage.getFileMsgTreeJsonData(diskUrl, depth);
                    JSONObject jsonObject = JSONObject.parseObject((String)fileMsgTreeJsonData);
                    ArrayList<String> expandedKeys = new ArrayList<String>(2);
                    FileServiceMonitorHandler.buildExpandedKeys(jsonObject, expandedKeys);
                    dataMap.put("fileMsgTreeTableData", jsonObject);
                    dataMap.put("expandedKeys", expandedKeys);
                    break block37;
                }
                if ("getChildrenFileMsgInfoList".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    String diskUrl = params.get("diskUrl");
                    String filePath = params.get("filePath");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)diskUrl) || org.apache.commons.lang.StringUtils.isEmpty((String)filePath)) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'diskUrl'/'depth' can not be null!"});
                    }
                    dataMap.put("childrenFileMsgInfoList", fileServerManage.getChildrenFileMsgInfoList(diskUrl, filePath));
                    break block37;
                }
                if ("getFileMsgInfo".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    String diskUrl = params.get("diskUrl");
                    String filePath = params.get("filePath");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)diskUrl) || org.apache.commons.lang.StringUtils.isEmpty((String)filePath)) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'diskUrl'/'depth' can not be null!"});
                    }
                    dataMap.put("fileMsgInfo", fileServerManage.getFileMsgInfo(diskUrl, filePath));
                    break block37;
                }
                if ("getMatchFileMsgInfoList".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    String searchTypeValue = params.get("searchTypeValue");
                    String searchScanSize = params.get("searchScanSize");
                    String searchKeys = params.get("searchKeys");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)searchTypeValue) || org.apache.commons.lang.StringUtils.isEmpty((String)searchKeys)) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'searchTypeValue'/'searchKey' can not be null!"});
                    }
                    if ((searchKeys = searchKeys.trim()).length() < 3) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The length of param 'searchKey' must >=3!"});
                    }
                    List diskUrlInfoList = fileServerManage.getDiskUrlInfoList(false);
                    ArrayList<FileMsgInfo> matchFileMsgInfoList = new ArrayList<FileMsgInfo>(10);
                    if ("fullFilePathSearch".equals(searchTypeValue)) {
                        for (DiskUrlInfo diskUrlInfo : diskUrlInfoList) {
                            FileMsgInfo fileMsgInfo;
                            if ("Error".equals(diskUrlInfo.getStatus()) || (fileMsgInfo = fileServerManage.getFileMsgInfo(diskUrlInfo.getDiskUrl(), searchKeys)) == null) continue;
                            matchFileMsgInfoList.add(fileMsgInfo);
                        }
                    } else {
                        if (org.apache.commons.lang.StringUtils.isEmpty((String)searchScanSize) || "undefined".equals(searchScanSize)) {
                            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"FileServiceMonitorHandler_7", (String)"\u641c\u7d22\u76ee\u5f55\u6df1\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0])});
                        }
                        int scanSize = Integer.parseInt(searchScanSize.trim());
                        String matchRules = this.getMatchRules(searchKeys);
                        for (DiskUrlInfo diskUrlInfo : diskUrlInfoList) {
                            if ("Error".equals(diskUrlInfo.getStatus())) continue;
                            matchFileMsgInfoList.addAll(fileServerManage.getMatchFileMsgInfoList(diskUrlInfo.getDiskUrl(), matchRules, scanSize));
                        }
                    }
                    dataMap.put("matchFileMsgInfoList", matchFileMsgInfoList);
                    break block37;
                }
                if ("buildScript".equals(actionType)) {
                    InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), "utf-8");
                    String query = CharStreams.toString((Readable)isr);
                    String paramStr = StringUtils.trimToNull((String)query);
                    JSONObject jsonObject = JSONObject.parseObject((String)paramStr);
                    String scType = (String)jsonObject.get((Object)"scType");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)scType) || jsonObject.get((Object)"fileMsgInfoList") == null) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'scType'/'fileMsgInfoList' can not be null!"});
                    }
                    String fileMsgInfoListStr = String.valueOf(jsonObject.get((Object)"fileMsgInfoList"));
                    List fileMsgInfoList = (List)JSONUtils.cast((String)fileMsgInfoListStr, (boolean)true, List.class, (Class[])new Class[]{FileMsgInfo.class});
                    HashMap filePathsMap = new HashMap(2);
                    for (FileMsgInfo fileMsgInfo : fileMsgInfoList) {
                        String sourceDiskUrl = fileMsgInfo.getSourceDiskUrl();
                        if (filePathsMap.get(sourceDiskUrl) == null) {
                            filePathsMap.put(sourceDiskUrl, new ArrayList(1));
                        }
                        ((List)filePathsMap.get(sourceDiskUrl)).add(fileMsgInfo.getFilePath());
                    }
                    ArrayList<String> scriptUrls = new ArrayList<String>();
                    if ("copy".equals(scType)) {
                        String targetDiskUrl = (String)jsonObject.get((Object)"targetDiskUrl");
                        if (org.apache.commons.lang.StringUtils.isEmpty((String)targetDiskUrl)) {
                            throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'targetDiskUrl' can not be null!"});
                        }
                        for (Map.Entry entry : filePathsMap.entrySet()) {
                            String url = fileServerManage.buildCopyScript((String)entry.getKey(), targetDiskUrl, ((List)entry.getValue()).toArray(new String[0]));
                            scriptUrls.add(url);
                        }
                        OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"FileServiceMonitorHandler_4", (String)"\u6587\u4ef6\u641c\u7d22", (Object[])new Object[0]), LangRes.get((String)"FileServiceMonitorHandler_5", (String)"\u62f7\u8d1d\u811a\u672c", (Object[])new Object[0]));
                    } else if ("rm".equals(scType)) {
                        for (Map.Entry entry : filePathsMap.entrySet()) {
                            String string = fileServerManage.buildRmScript((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                            scriptUrls.add(string);
                        }
                        OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"FileServiceMonitorHandler_4", (String)"\u6587\u4ef6\u641c\u7d22", (Object[])new Object[0]), LangRes.get((String)"FileServiceMonitorHandler_6", (String)"\u5220\u9664\u811a\u672c", (Object[])new Object[0]));
                    } else {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"buildScript error: unsupported scType " + scType});
                    }
                    dataMap.put("scriptUrls", this.buildStrBySplitChar(scriptUrls, ","));
                    break block37;
                }
                if ("downloadScript".equals(actionType)) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    String scriptUrls = params.get("scriptUrls");
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)scriptUrls)) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'scriptUrls' can not be null!"});
                    }
                    ArrayList<BatchDownloadRequest.File> downloadFiles = new ArrayList<BatchDownloadRequest.File>(1);
                    for (String url : scriptUrls.split(",")) {
                        if (!(url = url.trim()).startsWith("/tempfile")) {
                            throw new KDException(BosErrorCode.bOS, new Object[]{"The param 'scriptUrls' is illegal, scriptUrls=" + scriptUrls});
                        }
                        downloadFiles.add(new BatchDownloadRequest.File(url.substring(url.lastIndexOf("/") + 1), url));
                    }
                    if (!downloadFiles.isEmpty()) {
                        String zipName = "script.zip";
                        String userAgent = "attachment;filename=" + zipName;
                        exchange.getResponseHeaders().set("Content-Type", "application/zip");
                        exchange.getResponseHeaders().add("Content-Disposition", userAgent);
                        exchange.sendResponseHeaders(202, 0L);
                        FileService fileService = FileServiceFactory.getAttachmentFileService();
                        BatchDownloadRequest downloadRequest = new BatchDownloadRequest(zipName);
                        downloadRequest.setFiles(downloadFiles.toArray(new BatchDownloadRequest.File[0]));
                        fileService.batchDownload(downloadRequest, exchange.getResponseBody(), userAgent);
                        exchange.close();
                        return;
                    }
                    break block37;
                }
                throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported actionType:" + actionType});
            }
            catch (Exception e) {
                response.setCode(-1);
                if (e.getCause() instanceof SocketTimeoutException) {
                    response.setMsg(e.getCause().getMessage() + ExceptionHandler.getExceptionStackTrace(e));
                } else {
                    response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
                }
                log.error((Throwable)e);
            }
        }
        response.setData(dataMap);
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private String buildStrBySplitChar(List<String> stringList, String splitChar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringList.size(); ++i) {
            sb.append(stringList.get(i));
            if (i == stringList.size() - 1) continue;
            sb.append(splitChar);
        }
        return sb.toString();
    }

    private String getMatchRules(String searchKeys) {
        StringBuilder matchRules = new StringBuilder();
        String[] keyArr = searchKeys.split(" ");
        int flag = 0;
        for (String key : keyArr) {
            ++flag;
            if (!key.contains("*")) {
                matchRules.append("*").append(key).append("*");
            } else {
                matchRules.append(key);
            }
            if (flag == keyArr.length) continue;
            matchRules.append(",");
        }
        return matchRules.toString();
    }

    private static void buildExpandedKeys(JSONObject node, List<String> expandedKeys) {
        JSONArray children = node.getJSONArray("children");
        if (children != null && !children.isEmpty()) {
            expandedKeys.add(node.getString("sourceDiskUrl") + node.getString("filePath"));
            for (int i = 0; i < children.size(); ++i) {
                FileServiceMonitorHandler.buildExpandedKeys(children.getJSONObject(i), expandedKeys);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String getLangStr(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

