/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import java.time.LocalDateTime;
import kd.bos.eye.api.filemanager.IllegalPathDbHelper;
import kd.bos.eye.api.filemanager.IllegalPathRecordInfo;
import kd.bos.fileservice.permission.IllegalPathStorage;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IllegalPathStorageImpl
implements IllegalPathStorage {
    private static final Log logger = LogFactory.getLog(IllegalPathStorageImpl.class);

    public void write(String path, String tenantId, String accountId) {
        try {
            IllegalPathRecordInfo illegalPathRecordInfo = IllegalPathDbHelper.getRecordInfo(path, tenantId, accountId);
            if (illegalPathRecordInfo == null) {
                illegalPathRecordInfo = new IllegalPathRecordInfo();
                illegalPathRecordInfo.setId(ID.genLongId());
                illegalPathRecordInfo.setPath(path);
                illegalPathRecordInfo.setTenantId(tenantId);
                illegalPathRecordInfo.setAccountId(accountId);
                illegalPathRecordInfo.setMsg(" ");
            }
            illegalPathRecordInfo.setLastAccessTime(LocalDateTime.now());
            IllegalPathDbHelper.saveRecord(illegalPathRecordInfo);
        }
        catch (Exception e) {
            logger.error("Write IllegalPathRecord error!", (Throwable)e);
        }
    }
}

