/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.flamegraphs.vo.FlameConfigVO;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;

public class FlameConfigHandler
extends AbstractHttpHandler {
    private static Log LOGGER = LogFactory.getLog(FlameConfigHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String PLACEHOLDER = "/config/";
    private static final String DEFAULT_FLAMECONFIG_MAXSTOREDAYS = "7";
    private static final String DEFAULT_FLAMECONFIG_MAXSAMPLETIMESECONDS = "30";

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        block11: {
            int maxStoreDayProperty = Integer.getInteger("monitor.flamegraph.maxStoreDay", 14);
            int maxSamplingDurationProperty = Integer.getInteger("monitor.flamegraph.maxSampleTimeSeconds", 36000);
            ApiResponse response = new ApiResponse();
            response.setCode(-1);
            HashMap<String, FlameConfigVO> map = new HashMap<String, FlameConfigVO>(4);
            URI uri = exchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(PLACEHOLDER);
            String endPoint = reqPath.substring(pos + PLACEHOLDER.length());
            try {
                int maxSamplingDurationParam;
                int maxStoreDayParam;
                if (endPoint.equals("getConfig")) {
                    map.put("flameConfigVO", FlameConfigHandler.getFlameConfigVO());
                    response.setCode(0);
                    response.setData(map);
                    this.writeJson(JSONUtils.toString(response), exchange);
                    break block11;
                }
                if (!endPoint.equals("saveConfig")) break block11;
                FlameConfigVO flameConfigVOparam = ExchangeVueUtils.parseJsonFromPost(exchange, FlameConfigVO.class);
                if (flameConfigVOparam == null) {
                    response.setMsg(LangRes.get((String)"FlameConfigHandler_0", (String)"\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                if (flameConfigVOparam.getMaxStoreDays() == null || flameConfigVOparam.getMaxSampleTimeSeconds() == null) {
                    response.setMsg(LangRes.get((String)"FlameConfigHandler_1", (String)"\u975e\u6cd5\u8f93\u5165", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                try {
                    maxStoreDayParam = Integer.parseInt(flameConfigVOparam.getMaxStoreDays());
                    maxSamplingDurationParam = Integer.parseInt(flameConfigVOparam.getMaxSampleTimeSeconds());
                }
                catch (NumberFormatException ex) {
                    response.setMsg(LangRes.get((String)"FlameConfigHandler_1", (String)"\u975e\u6cd5\u8f93\u5165", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                if (maxStoreDayParam < 7 || maxStoreDayParam > maxStoreDayProperty) {
                    response.setMsg(LangRes.get((String)"FlameConfigHandler_2", (String)"\u6700\u5927\u4fdd\u5b58\u65f6\u957f\u975e\u6cd5\u8f93\u5165\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                if (maxSamplingDurationParam < 30 || maxSamplingDurationParam > maxSamplingDurationProperty) {
                    response.setMsg(LangRes.get((String)"FlameConfigHandler_2", (String)"\u6700\u5927\u4fdd\u5b58\u65f6\u957f\u975e\u6cd5\u8f93\u5165\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
                String userName = userInfo.get("user");
                FlameConfigVO flameConfigVOfromDB = FlameConfigHandler.getFlameConfigVOFromDB();
                if (flameConfigVOfromDB == null) {
                    this.insertFlameConfigVO(userName, flameConfigVOparam);
                    OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"FlameConfigHandler_3", (String)"\u706b\u7130\u56fe\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"FlameConfigHandler_5", (String)"\u65b0\u589e\u706b\u7130\u56fe\u914d\u7f6e", (Object[])new Object[0]));
                } else {
                    flameConfigVOparam.setId(flameConfigVOfromDB.getId());
                    this.updateFlameConfigVO(userName, flameConfigVOparam);
                    OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"FlameConfigHandler_3", (String)"\u706b\u7130\u56fe\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"FlameConfigHandler_6", (String)"\u66f4\u65b0\u706b\u7130\u56fe\u914d\u7f6e", (Object[])new Object[0]));
                }
                map.put("flameConfigVO", flameConfigVOparam);
                response.setCode(0);
                response.setData(map);
                this.writeJson(JSONUtils.toString(response), exchange);
            }
            catch (Exception e) {
                response.setCode(-1);
                response.setMsg("flameConfig exception, message: " + e.getMessage());
            }
        }
    }

    private int insertFlameConfigVO(String userName, FlameConfigVO flameConfigVO) {
        if (Boolean.getBoolean("isDBConfigured")) {
            return this.insertFromDB(userName, flameConfigVO);
        }
        return 0;
    }

    private int insertFromDB(String userName, FlameConfigVO flameConfigVO) {
        DBRequest dbRequest = new DBRequest();
        String insertSql = "insert into t_monitor_flameconfig(fid,fmaxstoredays,fmaxSampleTimeSeconds,fcreatoruser,fcreatetime,fupdateuser,fupdatetime) values (?,?,?,?,?,?,?)";
        ArrayList insertList = new ArrayList(7);
        Collections.addAll(insertList, DB.genLongId((String)"T_MONITOR_FLAMECONFIG"), Integer.parseInt(flameConfigVO.getMaxStoreDays()), Integer.parseInt(flameConfigVO.getMaxSampleTimeSeconds()), userName, LocalDateTime.now(), userName, LocalDateTime.now());
        DBRequest.InsertRequest insertRequest = new DBRequest.InsertRequest(insertSql, insertList);
        dbRequest.setInsertRequest(insertRequest);
        try {
            int insertSize = MetadataFactory.getStatement().executeInsert((Request)dbRequest);
            return insertSize;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    private int updateFlameConfigVO(String userName, FlameConfigVO flameConfigVO) {
        if (Boolean.getBoolean("isDBConfigured")) {
            return this.updateFromDB(userName, flameConfigVO);
        }
        return 0;
    }

    private int updateFromDB(String userName, FlameConfigVO flameConfigVO) {
        DBRequest dbRequest = new DBRequest();
        String updateSql = "update t_monitor_flameconfig set fmaxstoredays=?,fmaxSampleTimeSeconds=?,fupdateuser=?,fupdatetime=? where fid = ?";
        ArrayList updateList = new ArrayList(5);
        Collections.addAll(updateList, Integer.parseInt(flameConfigVO.getMaxStoreDays()), Integer.parseInt(flameConfigVO.getMaxSampleTimeSeconds()), userName, LocalDateTime.now(), flameConfigVO.getId());
        DBRequest.UpdateRequest updateRequest = new DBRequest.UpdateRequest(updateSql, updateList);
        dbRequest.setUpdateRequest(updateRequest);
        try {
            int insertSize = MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            return insertSize;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    private static FlameConfigVO getFlameConfigVOFromDB() {
        if (Boolean.getBoolean("isDBConfigured")) {
            return FlameConfigHandler.getFromDB();
        }
        return null;
    }

    public static FlameConfigVO getFlameConfigVO() {
        FlameConfigVO resultFlameConfigVO;
        if (Boolean.getBoolean("isDBConfigured") && (resultFlameConfigVO = FlameConfigHandler.getFromDB()) != null) {
            return resultFlameConfigVO;
        }
        return FlameConfigHandler.getDefaultFlameConfigVO();
    }

    private static FlameConfigVO getDefaultFlameConfigVO() {
        FlameConfigVO flameConfigVO = new FlameConfigVO();
        flameConfigVO.setMaxStoreDays(DEFAULT_FLAMECONFIG_MAXSTOREDAYS);
        flameConfigVO.setMaxSampleTimeSeconds(DEFAULT_FLAMECONFIG_MAXSAMPLETIMESECONDS);
        return flameConfigVO;
    }

    private static FlameConfigVO getFromDB() {
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,fmaxstoredays,fmaxSampleTimeSeconds from t_monitor_flameconfig";
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (CollectionUtils.isNotEmpty((Collection)retunList)) {
                Result result = (Result)retunList.get(0);
                FlameConfigVO flameConfigVO = new FlameConfigVO();
                flameConfigVO.setId(Long.parseLong(result.getString("fid")));
                flameConfigVO.setMaxStoreDays(result.getString("fmaxstoredays"));
                flameConfigVO.setMaxSampleTimeSeconds(result.getString("fmaxsampletimeseconds"));
                return flameConfigVO;
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return null;
    }
}

