/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.flamegraphs.Event;
import kd.bos.eye.api.flamegraphs.FlameConfigHandler;
import kd.bos.eye.api.flamegraphs.FlameGraphResultTask;
import kd.bos.eye.api.flamegraphs.FlameGraphs;
import kd.bos.eye.api.flamegraphs.Status;
import kd.bos.eye.api.flamegraphs.profiler.MyAsyncProfiler;
import kd.bos.eye.api.flamegraphs.profiler.utils.IOUtils;
import kd.bos.eye.api.flamegraphs.vo.FlameConfigVO;
import kd.bos.eye.api.flamegraphs.vo.FlameGraphVO;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class FlameGraphHandler
extends AbstractHttpHandler {
    private static final Log LOGGER = LogFactory.getLog(FlameGraphHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String PLACEHOLDER = "/graph/";
    protected static final int DELAY_SECONDS = 5;
    protected static final int WAIT_UNIT = 5;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(1);

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Object> response = new ApiResponse<Object>();
        response.setCode(-1);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        URI uri = exchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(PLACEHOLDER);
        String endPoint = reqPath.substring(pos + PLACEHOLDER.length());
        try {
            Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
            String userName = userInfo.get("user");
            if (endPoint.equals("list")) {
                FlameGraphVO flameGraphVO = ExchangeVueUtils.parseJsonFromPost(exchange, FlameGraphVO.class);
                List<FlameGraphVO> flameGraphVOList = this.findFlameGraphVOs(userName, flameGraphVO);
                int toRefreshSeconds = 0;
                if (CollectionUtils.isNotEmpty(flameGraphVOList)) {
                    List<FlameGraphVO> runningList = flameGraphVOList.stream().filter(tempGraphVO -> tempGraphVO.getTaskStatus().equals(Status.RUNNING.toString())).sorted(Comparator.comparingInt(o -> Integer.parseInt(o.getSampleTimeSeconds()))).collect(Collectors.toList());
                    List<FlameGraphVO> realRunningList = this.updateTimeoutTask(runningList);
                    if (CollectionUtils.isNotEmpty(realRunningList) && realRunningList.get(0) != null) {
                        String timeSeconds = realRunningList.get(0).getSampleTimeSeconds();
                        timeSeconds = StringUtils.isEmpty((String)timeSeconds) ? "0" : timeSeconds;
                        toRefreshSeconds = Integer.parseInt(timeSeconds) + 5;
                    }
                    if (realRunningList == null || runningList.size() != realRunningList.size()) {
                        flameGraphVOList = this.findFlameGraphVOs(userName, flameGraphVO);
                    }
                }
                map.put("flameGraphVOList", flameGraphVOList);
                map.put("toRefreshSeconds", toRefreshSeconds);
                this.findClusterEnv(map);
                response.setCode(0);
                response.setData(map);
            } else {
                if (endPoint.equals("add")) {
                    if (!Boolean.getBoolean("isDBConfigured")) {
                        response.setMsg(LangRes.get((String)"FlameGraphHandler_0", (String)"Monitor\u672a\u914d\u7f6e\u5b58\u50a8\u5e93", (Object[])new Object[0]));
                        this.writeJson(JSONUtils.toString(response), exchange);
                        return;
                    }
                    FlameGraphVO flameGraphVOparam = null;
                    String requestMethod = exchange.getRequestMethod();
                    if (requestMethod.equalsIgnoreCase("post")) {
                        flameGraphVOparam = ExchangeVueUtils.parseJsonFromPost(exchange, FlameGraphVO.class);
                        flameGraphVOparam.setAppName(Instance.getAppName());
                        flameGraphVOparam.setInstanceId(NetAddressUtils.getLocalIpAddress());
                    } else {
                        flameGraphVOparam = new FlameGraphVO();
                        flameGraphVOparam.setAppName(Instance.getAppName());
                        flameGraphVOparam.setInstanceId(NetAddressUtils.getLocalIpAddress());
                        Map<String, String> queryMap = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                        if (queryMap != null) {
                            flameGraphVOparam.setEvent(queryMap.get("event"));
                            flameGraphVOparam.setSampleTimeSeconds(queryMap.get("sampleTimeSeconds"));
                            if (StringUtils.isNotEmpty((String)queryMap.get("remark"))) {
                                flameGraphVOparam.setRemark(queryMap.get("remark"));
                            }
                        }
                    }
                    if (!this.isAddValid(exchange, response, flameGraphVOparam)) {
                        return;
                    }
                    FlameGraphVO flameGraphVOparamForDB = new FlameGraphVO();
                    flameGraphVOparamForDB.setInstanceId(flameGraphVOparam.getInstanceId());
                    ArrayList<String> taskStatusList = new ArrayList<String>();
                    Collections.addAll(taskStatusList, Status.READY.toString(), Status.RUNNING.toString());
                    flameGraphVOparamForDB.setTaskStatusList(taskStatusList);
                    FlameGraphVO flameGraphVOfromDB = this.getFromDB(null, flameGraphVOparamForDB);
                    if (StringUtils.isNotEmpty((String)flameGraphVOfromDB.getId())) {
                        Date createTimeDate;
                        Date expectFinishDate;
                        String createTime = flameGraphVOfromDB.getCreateTime();
                        if (createTime.contains(".")) {
                            createTime = createTime.substring(0, createTime.lastIndexOf("."));
                        }
                        if ((expectFinishDate = DateUtils.addSeconds((Date)(createTimeDate = DateUtils.parseDate((String)createTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"})), (int)(Integer.parseInt(flameGraphVOfromDB.getSampleTimeSeconds()) + 5))).before(new Date())) {
                            flameGraphVOfromDB.setTaskStatus(Status.ERROR.toString());
                            String msg = LangRes.get((String)"FlameGraphHandler_1", (String)"\u8282\u70b9\uff08{0}\uff09\u706b\u7130\u56fe\u5f02\u6b65\u4efb\u52a1\u8fd0\u884c\u5931\u8d25", (Object[])new Object[]{flameGraphVOfromDB.getInstanceId()});
                            flameGraphVOfromDB.setErrorMsg(msg);
                            FlameGraphHandler.updateFlameGraphVO(flameGraphVOfromDB);
                        } else {
                            String msg = LangRes.get((String)"FlameGraphHandler_2", (String)"\u8282\u70b9\uff08{0}\uff09\u4e0a\u4e00\u4e2a\u706b\u7130\u56fe\u4efb\u52a1\u4ecd\u5728\u751f\u6210\u4e2d\uff0c\u521b\u5efa\u5931\u8d25", (Object[])new Object[]{flameGraphVOparam.getInstanceId()});
                            response.setMsg(msg);
                            this.writeJson(JSONUtils.toString(response), exchange);
                            return;
                        }
                    }
                    flameGraphVOparam.setCreatorUser(userName);
                    this.generateFlameGraph(flameGraphVOparam);
                    LOGGER.info("insert into flameGraphTable success...");
                    OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"FlameGraphHandler_9", (String)"\u706b\u7130\u56fe\u7ba1\u7406", (Object[])new Object[0]), LangRes.get((String)"FlameGraphHandler_11", (String)"\u751f\u6210\u706b\u7130\u56fe\u6570\u636e,\u7c7b\u578b:{0},\u5b9e\u4f8b:{1}", (Object[])new Object[]{flameGraphVOparam.getEvent(), flameGraphVOparam.getInstanceId()}));
                    SCHEDULED_EXECUTOR.schedule(new FlameGraphResultTask(flameGraphVOparam), (long)(Integer.parseInt(flameGraphVOparam.getSampleTimeSeconds()) + 5), TimeUnit.SECONDS);
                    response.setCode(0);
                    response.setData(map);
                    String responseBody = JSONUtils.toString(response);
                    this.writeJson(responseBody, exchange);
                    return;
                }
                if (endPoint.equals("viewError")) {
                    Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                    FlameGraphVO flameGraphVOparam = new FlameGraphVO();
                    flameGraphVOparam.setId(params.get("id"));
                    FlameGraphVO flameGraphVOfromDB = this.getFromDB(null, flameGraphVOparam);
                    String errorMsg = "";
                    if (StringUtils.isNotEmpty((String)flameGraphVOfromDB.getErrorMsg())) {
                        errorMsg = flameGraphVOfromDB.getErrorMsg();
                    }
                    map.put("errorMsg", errorMsg);
                    response.setCode(0);
                    response.setData(map);
                } else {
                    if (endPoint.startsWith("view") || endPoint.startsWith("download")) {
                        String iosource;
                        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                        FlameGraphVO flameGraphVOfromDB = this.getFileSource(params.get("id"));
                        String flameGraphId = flameGraphVOfromDB.getFlameGraphId();
                        exchange.getResponseHeaders().set("Content-Type", "text/html");
                        if (endPoint.startsWith("download")) {
                            String fileName = flameGraphVOfromDB.getAppName() + "_" + flameGraphVOfromDB.getInstanceId() + "_" + flameGraphVOfromDB.getCreateTime() + ".html";
                            exchange.getResponseHeaders().add("Content-Disposition", "attachment;filename=" + fileName);
                        }
                        if ((iosource = System.getProperty("monitor.flamegraph.iosource", "db")).equalsIgnoreCase("redis")) {
                            try (InputStream is = FlameGraphs.getInputStream(flameGraphId);){
                                exchange.sendResponseHeaders(202, is.available());
                                IOUtils.copy(is, exchange.getResponseBody());
                            }
                        } else {
                            String fileSource = flameGraphVOfromDB.getFileSource();
                            exchange.sendResponseHeaders(202, fileSource.length());
                            exchange.getResponseBody().write(fileSource.getBytes());
                        }
                        exchange.close();
                        if (endPoint.startsWith("view")) {
                            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"FlameGraphHandler_9", (String)"\u706b\u7130\u56fe\u7ba1\u7406", (Object[])new Object[0]), LangRes.get((String)"FlameGraphHandler_12", (String)"\u67e5\u770b\u706b\u7130\u56fe\u6570\u636e,\u706b\u7130\u56feid:", (Object[])new Object[0]) + flameGraphId);
                        } else {
                            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"FlameGraphHandler_9", (String)"\u706b\u7130\u56fe\u7ba1\u7406", (Object[])new Object[0]), LangRes.get((String)"FlameGraphHandler_13", (String)"\u4e0b\u8f7d\u706b\u7130\u56fe\u6570\u636e,\u706b\u7130\u56feid:", (Object[])new Object[0]) + flameGraphId);
                        }
                        return;
                    }
                    if (endPoint.equals("delete")) {
                        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
                        String id = params.get("id");
                        int size = this.deleteFlameGraphVO(id);
                        if (size > 0) {
                            response.setCode(0);
                        } else {
                            map.put("errorMsg", "delete flameGraph error,fid=" + id);
                        }
                        response.setData(map);
                        OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"FlameGraphHandler_9", (String)"\u706b\u7130\u56fe\u7ba1\u7406", (Object[])new Object[0]), LangRes.get((String)"FlameGraphHandler_14", (String)"\u5220\u9664\u706b\u7130\u56fe\u6570\u636e,\u4e3b\u952eid:", (Object[])new Object[0]) + id);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("flameGraphException:{}", (Object)e.getMessage());
            response.setCode(-1);
            response.setMsg("flameGraph exception, message: " + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<FlameGraphVO> updateTimeoutTask(List<FlameGraphVO> runningList) {
        if (CollectionUtils.isEmpty(runningList)) {
            return Collections.emptyList();
        }
        ArrayList<FlameGraphVO> resultVOList = new ArrayList<FlameGraphVO>(runningList.size());
        ArrayList<FlameGraphVO> toUpdateVOList = new ArrayList<FlameGraphVO>(runningList.size());
        ArrayList<String> updateFidList = new ArrayList<String>(runningList.size());
        for (FlameGraphVO tempFlameGraphVO : runningList) {
            int sampleTimeSeconds = Integer.parseInt(tempFlameGraphVO.getSampleTimeSeconds());
            int taskMaxWaitSeconds = FlameGraphHandler.getTaskMaxWaitSeconds();
            String createTime = tempFlameGraphVO.getCreateTime();
            Date createTimeDate = null;
            try {
                if (createTime.contains(".")) {
                    createTime = createTime.substring(0, createTime.lastIndexOf("."));
                }
                createTimeDate = DateUtils.parseDate((String)createTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            }
            catch (ParseException e) {
                continue;
            }
            Date expectFinishDate = DateUtils.addSeconds((Date)createTimeDate, (int)(sampleTimeSeconds + taskMaxWaitSeconds));
            if (expectFinishDate.before(new Date())) {
                updateFidList.add(tempFlameGraphVO.getId());
                toUpdateVOList.add(tempFlameGraphVO);
                continue;
            }
            resultVOList.add(tempFlameGraphVO);
        }
        if (CollectionUtils.isNotEmpty(toUpdateVOList)) {
            ArrayList updateList = new ArrayList(10);
            DBRequest dbRequest = new DBRequest();
            StringBuilder sb = new StringBuilder();
            sb.append("update t_monitor_flamegraph set ").append("ferrormsg = ?,").append("ftaskstatus = ?,").append("fupdatetime = ? ").append("where fid in (");
            Collections.addAll(updateList, "Task time out", Status.ERROR.toString(), LocalDateTime.now());
            ArrayList<String> queryList = new ArrayList<String>(updateFidList.size());
            for (int i = 0; i < updateFidList.size(); ++i) {
                queryList.add("?");
                updateList.add(updateFidList.get(i));
            }
            String queryString = queryList.stream().collect(Collectors.joining(","));
            sb.append(queryString).append(")");
            String updateSql = sb.toString();
            DBRequest.UpdateRequest updateRequest = new DBRequest.UpdateRequest(updateSql, updateList);
            dbRequest.setUpdateRequest(updateRequest);
            try {
                MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.paramError, new Object[]{e});
            }
        }
        return resultVOList;
    }

    private void generateFlameGraph(FlameGraphVO flameGraphVOparam) {
        String flameGraphId = MyAsyncProfiler.execute(Integer.parseInt(flameGraphVOparam.getSampleTimeSeconds()), Collections.singletonList(Event.getValueOf(flameGraphVOparam.getEvent())));
        flameGraphVOparam.setFlameGraphId(flameGraphId);
        flameGraphVOparam.setTaskStatus(Status.RUNNING.toString());
        this.insertFlameGraphVO(flameGraphVOparam);
    }

    private boolean isAddValid(HttpExchange exchange, ApiResponse<Object> response, FlameGraphVO flameGraphVOparam) throws IOException {
        boolean isInstanceIdValid = this.validAppNameAndInstanceId(flameGraphVOparam);
        if (!isInstanceIdValid) {
            response.setMsg(LangRes.get((String)"FlameGraphHandler_3", (String)"\u975e\u6cd5\u8bf7\u6c42\uff0c\u5df2\u62e6\u622a", (Object[])new Object[0]));
            this.writeJson(JSONUtils.toString(response), exchange);
            return false;
        }
        String event = flameGraphVOparam.getEvent();
        Event eventEnum = Event.getValueOf(event);
        if (eventEnum == null) {
            response.setMsg(LangRes.get((String)"FlameGraphHandler_3", (String)"\u975e\u6cd5\u8bf7\u6c42\uff0c\u5df2\u62e6\u622a", (Object[])new Object[0]));
            this.writeJson(JSONUtils.toString(response), exchange);
            return false;
        }
        String sampleTimeSeconds = flameGraphVOparam.getSampleTimeSeconds();
        if (sampleTimeSeconds == null || sampleTimeSeconds.equalsIgnoreCase("undefined")) {
            response.setMsg(LangRes.get((String)"FlameGraphHandler_4", (String)"\u91c7\u6837\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
            this.writeJson(JSONUtils.toString(response), exchange);
            return false;
        }
        int sampleTimeSecondsParam = Integer.parseInt(sampleTimeSeconds);
        FlameConfigVO flameConfigVOfromDB = FlameConfigHandler.getFlameConfigVO();
        int maxSamplingDurationDB = Integer.parseInt(flameConfigVOfromDB.getMaxSampleTimeSeconds());
        if (sampleTimeSecondsParam < 10 || sampleTimeSecondsParam > maxSamplingDurationDB) {
            response.setMsg(LangRes.get((String)"FlameGraphHandler_5", (String)"\u91c7\u6837\u65f6\u957f\u975e\u6cd5\u8f93\u5165\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]));
            this.writeJson(JSONUtils.toString(response), exchange);
            return false;
        }
        if (StringUtils.isNotEmpty((String)flameGraphVOparam.getRemark()) && flameGraphVOparam.getRemark().length() > 50) {
            flameGraphVOparam.setRemark(flameGraphVOparam.getRemark().substring(50));
        }
        return true;
    }

    private void findClusterEnv(Map<String, Object> map) {
        HashSet<String> appNames = new HashSet<String>(8);
        HashSet<String> instanceIdSet = new HashSet<String>(8);
        HashSet<String> ipPortSet = new HashSet<String>(8);
        List allNodeInfo = ServiceInfoFactory.get().getServiceList();
        HashMap<String, ArrayList<String>> appName2instanceIdsMap = new HashMap<String, ArrayList<String>>(allNodeInfo.size());
        for (ServiceInfo tempServiceInfo : allNodeInfo) {
            String tempAppName = tempServiceInfo.getAppName();
            appNames.add(tempAppName);
            instanceIdSet.add(tempServiceInfo.getIp());
            ipPortSet.add(tempServiceInfo.getIp() + ":" + tempServiceInfo.getMonitorPort());
            ArrayList<String> tempInstanceIdSet = (ArrayList<String>)appName2instanceIdsMap.get(tempAppName);
            if (tempInstanceIdSet == null) {
                tempInstanceIdSet = new ArrayList<String>(4);
                appName2instanceIdsMap.putIfAbsent(tempAppName, tempInstanceIdSet);
            }
            tempInstanceIdSet.add(tempServiceInfo.getIp());
        }
        map.put("appNames", appNames);
        map.put("instanceIdList", instanceIdSet);
        map.put("ipPortList", ipPortSet);
        map.put("appName2instanceIdList", appName2instanceIdsMap);
        FlameConfigVO flameConfigVOfromDB = FlameConfigHandler.getFlameConfigVO();
        map.put("maxStoreDays", flameConfigVOfromDB.getMaxStoreDays());
        map.put("maxSampleTimeSeconds", flameConfigVOfromDB.getMaxSampleTimeSeconds());
        map.put("isOSSupport", this.isOSSupport());
        map.put("isOSArch", System.getProperty("os.arch"));
    }

    private boolean isOSSupport() {
        String osArch = System.getProperty("os.arch");
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("flame/flame.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("can not read flame/flame.json!", (Throwable)e);
        }
        JSONObject allJSONObject = JSON.parseObject((String)sb.toString());
        JSONArray supportedArchitectures = (JSONArray)allJSONObject.get((Object)"supportedArchitectures");
        for (Object architecture : supportedArchitectures) {
            if (!architecture.equals(osArch)) continue;
            return true;
        }
        return false;
    }

    private int insertFlameGraphVO(FlameGraphVO flameGraphVO) {
        DBRequest dbRequest = new DBRequest();
        long id = DB.genLongId((String)"t_monitor_flamegraph");
        flameGraphVO.setId(String.valueOf(id));
        String insertSql = "insert into t_monitor_flamegraph(fid,fevent,fappname,finstanceid,fflamegraphid,fremark,fcreatoruser,ftaskstatus,fsampletimeseconds,fcreatetime) values (?,?,?,?,?,?,?,?,?,?)";
        ArrayList insertList = new ArrayList(10);
        Collections.addAll(insertList, id, flameGraphVO.getEvent(), flameGraphVO.getAppName(), flameGraphVO.getInstanceId(), flameGraphVO.getFlameGraphId(), StringUtils.isEmpty((String)flameGraphVO.getRemark()) ? " " : flameGraphVO.getRemark(), flameGraphVO.getCreatorUser(), flameGraphVO.getTaskStatus(), Integer.parseInt(flameGraphVO.getSampleTimeSeconds()), LocalDateTime.now());
        DBRequest.InsertRequest insertRequest = new DBRequest.InsertRequest(insertSql, insertList);
        dbRequest.setInsertRequest(insertRequest);
        try {
            int insertSize = MetadataFactory.getStatement().executeInsert((Request)dbRequest);
            return insertSize;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    public static int updateFlameGraphVO(FlameGraphVO flameGraphVO) {
        ArrayList<String> updateList = new ArrayList<String>(4);
        DBRequest dbRequest = new DBRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("update t_monitor_flamegraph set ").append("fflamegraphid = ?,").append("ftaskstatus = ?,");
        Collections.addAll(updateList, flameGraphVO.getFlameGraphId(), flameGraphVO.getTaskStatus());
        if (StringUtils.isNotEmpty((String)flameGraphVO.getErrorMsg())) {
            sb.append("ferrormsg = ?,");
            updateList.add(flameGraphVO.getErrorMsg());
        }
        if (StringUtils.isNotEmpty((String)flameGraphVO.getFileSource())) {
            sb.append("ffilesource = ?,");
            updateList.add(flameGraphVO.getFileSource());
        }
        sb.append("fupdatetime = ? ");
        sb.append("where fid = ?");
        String updateSql = sb.toString();
        Collections.addAll(updateList, LocalDateTime.now(), flameGraphVO.getId());
        DBRequest.UpdateRequest updateRequest = new DBRequest.UpdateRequest(updateSql, updateList);
        dbRequest.setUpdateRequest(updateRequest);
        try {
            int updateSize = MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            return updateSize;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    public List<FlameGraphVO> findFlameGraphVOs(String userName, FlameGraphVO flameGraphVO) throws Exception {
        if (Boolean.getBoolean("isDBConfigured")) {
            return this.findListFromDB(userName, flameGraphVO);
        }
        return null;
    }

    private List<FlameGraphVO> findListFromDB(String userName, FlameGraphVO flameGraphVO) {
        DBRequest dbRequest = new DBRequest();
        StringBuilder sb = new StringBuilder();
        String querySql = "select fid,fevent,fappname,finstanceid,fremark,fcreatetime,fcreatoruser,ftaskstatus,fflamegraphid,fsampletimeseconds,fupdatetime from t_monitor_flamegraph where fcreatoruser = ?";
        sb.append(querySql);
        ArrayList<String> queryList = new ArrayList<String>(10);
        queryList.add(userName);
        if (flameGraphVO != null) {
            if (StringUtils.isNotEmpty((String)flameGraphVO.getAppName())) {
                sb.append(" and fappname = ?");
                queryList.add(flameGraphVO.getAppName());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getInstanceId())) {
                sb.append(" and finstanceid = ?");
                queryList.add(flameGraphVO.getInstanceId());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getEvent())) {
                sb.append(" and fevent = ?");
                queryList.add(flameGraphVO.getEvent());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getRemark())) {
                sb.append(" and fremark like ? ");
                if (this.needContainEscape()) {
                    sb.append(" escape '\\' ");
                }
                String remark = flameGraphVO.getRemark();
                remark = remark.replace("%", "\\%");
                queryList.add("%" + remark + "%");
            }
        }
        sb.append(" order by fcreatetime desc");
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
        ArrayList<FlameGraphVO> resultList = null;
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<FlameGraphVO>(retunList.size());
            for (Result row : retunList) {
                FlameGraphVO tempFlameGraphVO = new FlameGraphVO();
                tempFlameGraphVO.setId(row.getString("fid"));
                tempFlameGraphVO.setRemark(row.getString("fremark"));
                tempFlameGraphVO.setEvent(row.getString("fevent"));
                tempFlameGraphVO.setInstanceId(row.getString("finstanceid"));
                tempFlameGraphVO.setCreateTime(row.getString("fcreatetime"));
                tempFlameGraphVO.setSampleTimeSeconds(row.getString("fsampletimeseconds"));
                tempFlameGraphVO.setAppName(row.getString("fappname"));
                tempFlameGraphVO.setUpdateTime(row.getString("fupdatetime"));
                tempFlameGraphVO.setFlameGraphId(row.getString("fflamegraphid"));
                tempFlameGraphVO.setCreatorUser(row.getString("fcreatoruser"));
                tempFlameGraphVO.setTaskStatus(row.getString("ftaskstatus"));
                resultList.add(tempFlameGraphVO);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }

    private boolean needContainEscape() {
        DBConfig dbConfig = null;
        try {
            dbConfig = DBHelper.getDbConfig();
        }
        catch (Exception e) {
            return false;
        }
        Integer dbType = dbConfig.getDbType();
        return dbType.intValue() == DBType.DM.getValue() || dbType.intValue() == DBType.Oracle.getValue();
    }

    private int deleteFlameGraphVO(String fid) {
        ArrayList<String> deleteList = new ArrayList<String>(1);
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from t_monitor_flamegraph where fid = ?";
        deleteList.add(fid);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return MetadataFactory.getStatement().executeDelete((Request)dbRequest);
    }

    private FlameGraphVO getFileSource(String fid) {
        FlameGraphVO resultFlameGraphVO = new FlameGraphVO();
        ArrayList<String> queryList = new ArrayList<String>(1);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,fappname,finstanceid,fcreatetime,fflamegraphid,ffilesource from t_monitor_flamegraph where fid = ?";
        queryList.add(fid);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (CollectionUtils.isNotEmpty((Collection)retunList)) {
                Result row = (Result)retunList.get(0);
                resultFlameGraphVO.setId(row.getString("fid"));
                resultFlameGraphVO.setAppName(row.getString("fappname"));
                resultFlameGraphVO.setInstanceId(row.getString("finstanceid"));
                resultFlameGraphVO.setFlameGraphId(row.getString("fflamegraphid"));
                resultFlameGraphVO.setFileSource(row.getString("ffilesource"));
                resultFlameGraphVO.setCreateTime(row.getString("fcreatetime"));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultFlameGraphVO;
    }

    private FlameGraphVO getFromDB(String userName, FlameGraphVO flameGraphVO) {
        FlameGraphVO resultFlameGraphVO = new FlameGraphVO();
        ArrayList<String> queryList = new ArrayList<String>(10);
        DBRequest dbRequest = new DBRequest();
        StringBuilder sb = new StringBuilder();
        String querySql = "select fid,fevent,fappname,finstanceid,fremark,fcreatetime,fcreatoruser,ftaskstatus,fflamegraphid,fsampletimeseconds,fupdatetime,ferrormsg from t_monitor_flamegraph";
        sb.append(querySql);
        StringBuilder queryParamSb = new StringBuilder();
        if (flameGraphVO != null) {
            if (StringUtils.isNotEmpty((String)flameGraphVO.getInstanceId())) {
                queryParamSb.append(" finstanceid = ?");
                queryList.add(flameGraphVO.getInstanceId());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getAppName())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" finstanceid = ?");
                queryList.add(flameGraphVO.getAppName());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getEvent())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" fevent = ?");
                queryList.add(flameGraphVO.getEvent());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getTaskStatus())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" ftaskstatus = ?");
                queryList.add(flameGraphVO.getTaskStatus());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getId())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" fid = ?");
                queryList.add(flameGraphVO.getId());
            }
            if (StringUtils.isNotEmpty((String)flameGraphVO.getRemark())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" fremark like ?");
                queryList.add("%" + flameGraphVO.getRemark() + "%");
            }
            if (CollectionUtils.isNotEmpty(flameGraphVO.getTaskStatusList())) {
                if (queryParamSb.length() > 0) {
                    queryParamSb.append(" and ");
                }
                queryParamSb.append(" ftaskstatus in (");
                StringBuilder taskStatusPlaceholder = new StringBuilder();
                for (String tempStatus : flameGraphVO.getTaskStatusList()) {
                    taskStatusPlaceholder.append("?,");
                    queryList.add(tempStatus);
                }
                String taskStatusPlaceholderStr = taskStatusPlaceholder.substring(0, taskStatusPlaceholder.length() - 1);
                queryParamSb.append(taskStatusPlaceholderStr).append(")");
            }
        }
        if (StringUtils.isNotEmpty((String)userName)) {
            if (queryParamSb.length() > 0) {
                queryParamSb.append(" and ");
            }
            sb.append(" fcreatoruser = ?");
            queryList.add(userName);
        }
        if (queryParamSb.length() > 0) {
            sb.append(" where ").append((CharSequence)queryParamSb);
        }
        sb.append(" order by fcreatetime desc");
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            if (CollectionUtils.isNotEmpty((Collection)retunList)) {
                Result row = (Result)retunList.get(0);
                resultFlameGraphVO.setAppName(row.getString("fappname"));
                resultFlameGraphVO.setSampleTimeSeconds(row.getString("fsampletimeseconds"));
                resultFlameGraphVO.setUpdateTime(row.getString("fupdatetime"));
                resultFlameGraphVO.setFlameGraphId(row.getString("fflamegraphid"));
                resultFlameGraphVO.setCreatorUser(row.getString("fcreatoruser"));
                resultFlameGraphVO.setTaskStatus(row.getString("ftaskstatus"));
                resultFlameGraphVO.setId(row.getString("fid"));
                resultFlameGraphVO.setRemark(row.getString("fremark"));
                resultFlameGraphVO.setEvent(row.getString("fevent"));
                resultFlameGraphVO.setInstanceId(row.getString("finstanceid"));
                resultFlameGraphVO.setCreateTime(row.getString("fcreatetime"));
                resultFlameGraphVO.setErrorMsg(row.getString("ferrormsg"));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultFlameGraphVO;
    }

    private boolean validAppNameAndInstanceId(FlameGraphVO flameGraphVO) {
        List allNodeInfo = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo tempServiceInfo : allNodeInfo) {
            if (!tempServiceInfo.getAppName().equals(flameGraphVO.getAppName()) || !tempServiceInfo.getIp().equals(flameGraphVO.getInstanceId())) continue;
            return true;
        }
        return false;
    }

    static int getTaskMaxWaitTimes() {
        return Integer.getInteger("monitor.flamegraph.resulttask.maxWaitTimes", 9);
    }

    static int getTaskMaxWaitSeconds() {
        return 5 + FlameGraphHandler.getTaskMaxWaitTimes() * 5;
    }
}

