/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs.profiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.flamegraphs.Event;
import kd.bos.eye.api.flamegraphs.FlameGraphsMsg;
import kd.bos.eye.api.flamegraphs.Status;
import kd.bos.eye.api.flamegraphs.cache.FlameGraphsCache;
import kd.bos.eye.api.flamegraphs.profiler.AsyncProfiler;
import kd.bos.eye.api.flamegraphs.profiler.utils.IOUtils;
import kd.bos.eye.api.flamegraphs.profiler.utils.OSUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.FileUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class MyAsyncProfiler {
    public static final String FILE_SUFFIX = ".html";
    private static AsyncProfiler profiler = null;
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"FlameGraphs-Thread", (int)3, (int)10);
    private static Log log = LogFactory.getLog(MyAsyncProfiler.class);

    public static String execute(final int sampleTimeSeconds, final List<Event> events) {
        final String id = MyAsyncProfiler.createId();
        FlameGraphsCache.cacheMsg(id, new FlameGraphsMsg(Status.READY, "READY"));
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MyAsyncProfiler.isRunning()) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"The current node is generating a flame graphs, cannot be repeated!"});
                    }
                    FlameGraphsMsg flameGraphsMsg = MyAsyncProfiler.startCollect(id, events);
                    if (Status.RUNNING == flameGraphsMsg.getStatus()) {
                        Thread.sleep(sampleTimeSeconds * 1000);
                        MyAsyncProfiler.stopCollect(id, events);
                    }
                }
                catch (Throwable e) {
                    FlameGraphsCache.cacheMsg(id, new FlameGraphsMsg(Status.ERROR, e.getMessage()));
                    log.error(e);
                }
                finally {
                    MyAsyncProfiler.delete(MyAsyncProfiler.getTmpFilePath(id));
                }
            }
        });
        return id;
    }

    private static boolean isRunning() throws IOException {
        AsyncProfiler asyncProfiler = MyAsyncProfiler.profilerInstance();
        String msg = asyncProfiler.execute("status");
        return StringUtils.isNotEmpty((String)msg) && msg.contains("Profiling is running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FlameGraphsMsg stopCollect(String id, List<Event> events) throws IOException {
        try (InputStream inputStream = null;){
            StringBuilder stopCommand = new StringBuilder();
            stopCommand.append("stop").append(MyAsyncProfiler.getCommandSuffix(id, events, true));
            AsyncProfiler asyncProfiler = MyAsyncProfiler.profilerInstance();
            String msg = asyncProfiler.execute(stopCommand.toString());
            FlameGraphsMsg flameGraphsMsg = null;
            if (msg.startsWith("OK")) {
                inputStream = MyAsyncProfiler.getInputStream(MyAsyncProfiler.getTmpFilePath(id));
                String cacheFileUrl = FlameGraphsCache.cacheInputStream(id, inputStream);
                StringBuilder stringBuilder = new StringBuilder(msg);
                stringBuilder.append(",cacheFileUrl=").append(cacheFileUrl);
                flameGraphsMsg = new FlameGraphsMsg(Status.OK, stringBuilder.toString());
            } else {
                flameGraphsMsg = new FlameGraphsMsg(Status.ERROR, msg);
            }
            FlameGraphsCache.cacheMsg(id, flameGraphsMsg);
            FlameGraphsMsg flameGraphsMsg2 = flameGraphsMsg;
            return flameGraphsMsg2;
        }
    }

    private static FlameGraphsMsg startCollect(String id, List<Event> events) throws IOException {
        StringBuilder startCommand = new StringBuilder();
        startCommand.append("start").append(MyAsyncProfiler.getCommandSuffix(id, events, false));
        AsyncProfiler asyncProfiler = MyAsyncProfiler.profilerInstance();
        String msg = asyncProfiler.execute(startCommand.toString());
        FlameGraphsMsg flameGraphsMsg = null;
        flameGraphsMsg = msg.contains("Profiling started") ? new FlameGraphsMsg(Status.RUNNING, msg) : new FlameGraphsMsg(Status.ERROR, msg);
        FlameGraphsCache.cacheMsg(id, flameGraphsMsg);
        return flameGraphsMsg;
    }

    private static InputStream getInputStream(String fileUrl) {
        File file = new File(FilenameUtils.normalize((String)(fileUrl = FileUtils.checkFileUrl((String)fileUrl))));
        if (file.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                log.error(e.getMessage());
            }
            return fis;
        }
        return null;
    }

    private static boolean delete(String fileUrl) {
        File file = new File(FilenameUtils.normalize((String)fileUrl));
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    private static String getCommandSuffix(String id, List<Event> events, boolean withFile) {
        StringBuilder commandSuffix = new StringBuilder();
        commandSuffix.append(",event=");
        for (Event event : events) {
            commandSuffix.append(event.toString()).append(",");
        }
        if (withFile) {
            commandSuffix.append("file=").append(MyAsyncProfiler.getTmpFilePath(id));
        }
        commandSuffix.append(",interval=10000000,framebuf=1000000,threads");
        return commandSuffix.toString();
    }

    private static String getTmpFilePath(String id) {
        StringBuilder tmpFilePath = new StringBuilder();
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        tmpFilePath.append(javaTmpDir);
        if (!javaTmpDir.endsWith("/")) {
            tmpFilePath.append("/");
        }
        tmpFilePath.append(id).append(FILE_SUFFIX);
        return tmpFilePath.toString();
    }

    private static String createId() {
        return "FlameGraphs-" + UUID.randomUUID().toString();
    }

    private static AsyncProfiler profilerInstance() {
        boolean isLinux = OSUtils.isLinux();
        boolean isMac = OSUtils.isMac();
        if (!isLinux && !isMac) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"Current OS do not support AsyncProfiler, Only support Linux/Mac."});
        }
        if (profiler != null) {
            return profiler;
        }
        String libPath = null;
        if (isMac) {
            libPath = "async-profiler/libasyncProfiler-mac.so";
        }
        if (isLinux) {
            libPath = "async-profiler/libasyncProfiler-linux-x64.so";
            if (OSUtils.isArm64()) {
                libPath = "async-profiler/libasyncProfiler-linux-arm64.so";
            }
        }
        FileOutputStream tmpLibOutputStream = null;
        InputStream libInputStream = null;
        try {
            File tmpLibFile = File.createTempFile("ArthasJniLibrary", null);
            tmpLibOutputStream = new FileOutputStream(tmpLibFile);
            libInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(libPath);
            IOUtils.copy(libInputStream, tmpLibOutputStream);
            libPath = tmpLibFile.getAbsolutePath();
        }
        catch (Throwable e) {
            try {
                throw new KDException(BosErrorCode.bOS, "try to copy lib error! libPath=" + libPath, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(libInputStream);
                IOUtils.close(tmpLibOutputStream);
                throw throwable;
            }
        }
        IOUtils.close(libInputStream);
        IOUtils.close(tmpLibOutputStream);
        profiler = AsyncProfiler.getInstance(libPath);
        return profiler;
    }
}

