/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class HealthCheckConfig {
    private static final Log logger = LogFactory.getLog(HealthCheckConfig.class);
    private static final String CONFIG_KEY = "monitor.healthcheck.config";
    private static final String HEALTH_CHECK_USER = "monitor.healthcheck.account.user";
    private static final String HEALTH_CHECK_PD = "monitor.healthcheck.account.pd";
    private static Properties properties = new Properties();

    public static String getConfig(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static boolean checkAuth(String userName, String passwd) {
        String user = System.getProperty(HEALTH_CHECK_USER);
        String pd = System.getProperty(HEALTH_CHECK_PD);
        if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)pd)) {
            return false;
        }
        String decode = Encrypters.decode((String)pd);
        return user.equals(userName) && decode.equals(passwd);
    }

    static {
        ConfigurationUtil.observeString((String)CONFIG_KEY, (String)"", value -> {
            if (StringUtils.isNotEmpty((String)value)) {
                try (StringReader reader = new StringReader((String)value);){
                    properties.load(reader);
                }
                catch (IOException ioException) {
                    logger.warn("load healthCheck config error");
                }
            }
        });
    }
}

