/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi.component;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.component.ComponentCheckResult;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class RedisCheckExecutor
implements HealthCheck {
    private static Map<String, Object> poolMap = new HashMap<String, Object>(8);
    private static final String HEALTH_CHECK_KEY = "key-clusterHealthCheck-" + Instance.getInstanceId();
    private static final String HEALTH_CHECK_VALUE = "value-clusterHealthCheck-" + Instance.getInstanceId();

    @Override
    public List<CheckResult> check() {
        ArrayList<CheckResult> retList = new ArrayList<CheckResult>(poolMap.size());
        for (Map.Entry<String, Object> next : poolMap.entrySet()) {
            long start = System.currentTimeMillis();
            String url = next.getKey();
            try {
                JedisClient client = RedisFactory.getJedisClient((String)url);
                client.set(HEALTH_CHECK_KEY, HEALTH_CHECK_VALUE);
                client.get(HEALTH_CHECK_KEY);
                client.del(HEALTH_CHECK_KEY);
            }
            catch (Exception e) {
                retList.add(ComponentCheckResult.error(url, "REDIS", "set/get/del operate has error, exception message: " + e.getMessage()));
                continue;
            }
            long eclipseTime = System.currentTimeMillis() - start;
            int level = HealthCheck.getLevel(eclipseTime);
            retList.add(ComponentCheckResult.ofResult(url, "REDIS", String.format("check cost time: %d ms", eclipseTime), level));
        }
        return retList;
    }

    static {
        try {
            Class<?> redisFactory = Class.forName("kd.bos.redis.RedisFactory");
            Field filed = redisFactory.getDeclaredField("poolMap");
            filed.setAccessible(true);
            poolMap = (Map)filed.get(redisFactory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

