/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.component.ComponentCheckResult;
import kd.bos.instance.Instance;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZookeeperCheckExecutor
implements HealthCheck {
    private static final String ZOOKEEPER_HEALTH_CHECK_KEY_SUF = Instance.getInstanceId() + "-healthCheck";

    @Override
    public List<CheckResult> check() {
        ConcurrentHashMap poolMap = ZKFactory.poolMap;
        ArrayList<CheckResult> retList = new ArrayList<CheckResult>(poolMap.size());
        for (Map.Entry next : poolMap.entrySet()) {
            String url = (String)next.getKey();
            long start = System.currentTimeMillis();
            try {
                CuratorFramework client = ZKFactory.getZKClient((String)url);
                String rootPath = ZKFactory.getZkRootPath((String)url);
                String p = rootPath + ZOOKEEPER_HEALTH_CHECK_KEY_SUF;
                Stat exists = (Stat)client.checkExists().forPath(p);
                if (exists == null) {
                    ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(p);
                }
                client.delete().forPath(p);
            }
            catch (Exception e) {
                retList.add(ComponentCheckResult.error(url, "ZOOKEEPER", "create/delete path has error,exception message: " + e.getMessage()));
                continue;
            }
            long eclipseTime = System.currentTimeMillis() - start;
            int level = HealthCheck.getLevel(eclipseTime);
            retList.add(ComponentCheckResult.ofResult(url, "ZOOKEEPER", String.format("check cost time: %d ms", eclipseTime), level));
        }
        return retList;
    }
}

