/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.jmx;

import com.alibaba.fastjson.JSONObject;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import kd.bos.util.JmxUtils;
import kd.bos.util.NetAddressUtils;

public class JMXRealtimeProvider {
    private static final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String LOCAL_IP = NetAddressUtils.getLocalIpAddress();
    private static final String MAX = "max";
    private static final String USED = "used";
    private static final String COMMITTED = "committed";
    private static final String VALUE = "value";
    private static final long unit = 0x100000L;
    private static ObjectName memory;
    private static ObjectName operatingSystem;
    private static ObjectName memoryPoolMetaspace;
    private static ObjectName codeCache;
    private static String gcType;

    public static JSONObject getMetrics(List<String> localMetrics) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss");
        JSONObject ret = new JSONObject();
        Date now = new Date();
        String nowStr = dateFormat.format(now);
        for (String metric : localMetrics) {
            try {
                JSONObject metricValue = JMXRealtimeProvider.getMetricValue(metric);
                ret.put(LOCAL_IP + "-" + metric, (Object)metricValue);
                metricValue.put("xAxis", (Object)nowStr);
            }
            catch (Exception e) {}
        }
        return ret;
    }

    private static JSONObject getMetricValue(String metric) throws AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        JSONObject data = new JSONObject();
        switch (metric) {
            case "heapMemory": {
                CompositeDataSupport memoryDataSupport = (CompositeDataSupport)platformMBeanServer.getAttribute(memory, "HeapMemoryUsage");
                JMXRealtimeProvider.fillData(memoryDataSupport, data);
                break;
            }
            case "nonHeapMemory": {
                CompositeDataSupport nonHeapMemory = (CompositeDataSupport)platformMBeanServer.getAttribute(memory, "NonHeapMemoryUsage");
                JMXRealtimeProvider.fillData(nonHeapMemory, data);
                break;
            }
            case "metaspace": {
                CompositeDataSupport metaspace = (CompositeDataSupport)platformMBeanServer.getAttribute(memoryPoolMetaspace, "Usage");
                JMXRealtimeProvider.fillData(metaspace, data);
                break;
            }
            case "codeCache": {
                CompositeDataSupport codeCacheDataSupport = (CompositeDataSupport)platformMBeanServer.getAttribute(codeCache, "Usage");
                JMXRealtimeProvider.fillData(codeCacheDataSupport, data);
            }
            case "cpuLoadAvg": {
                double processCpuLoad = (Double)platformMBeanServer.getAttribute(operatingSystem, "ProcessCpuLoad");
                data.put(VALUE, (Object)(processCpuLoad * 100.0));
                break;
            }
            case "GCDuration": {
                List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean gc : gcMxBeans) {
                    if ("G1 Old Generation".equals(gc.getName()) || "PS MarkSweep".equals(gc.getName())) {
                        data.put("fullGc", (Object)gc.getCollectionTime());
                        data.put("fullGcCount", (Object)gc.getCollectionCount());
                        continue;
                    }
                    data.put("youngGc", (Object)gc.getCollectionTime());
                    data.put("youngGcCount", (Object)gc.getCollectionCount());
                }
                break;
            }
            case "class": {
                Object classCount = JmxUtils.getAtt((String)"java.lang:type=ClassLoading", (String)"LoadedClassCount");
                data.put(VALUE, classCount);
                break;
            }
            case "systemMem": {
                long totalPhysicalMemorySize = (Long)JmxUtils.getAtt((String)"java.lang:type=OperatingSystem", (String)"TotalPhysicalMemorySize");
                long freePhysicalMemorySize = (Long)JmxUtils.getAtt((String)"java.lang:type=OperatingSystem", (String)"FreePhysicalMemorySize");
                data.put("total", (Object)(totalPhysicalMemorySize / 0x100000L));
                data.put("free", (Object)(freePhysicalMemorySize / 0x100000L));
                data.put(USED, (Object)((totalPhysicalMemorySize - freePhysicalMemorySize) / 0x100000L));
                break;
            }
            case "swapMem": {
                long totalSwapSpaceSize = (Long)JmxUtils.getAtt((String)"java.lang:type=OperatingSystem", (String)"TotalSwapSpaceSize");
                long freeSwapSpaceSize = (Long)JmxUtils.getAtt((String)"java.lang:type=OperatingSystem", (String)"FreeSwapSpaceSize");
                data.put("total", (Object)(totalSwapSpaceSize / 0x100000L));
                data.put("free", (Object)(freeSwapSpaceSize / 0x100000L));
                data.put(USED, (Object)((totalSwapSpaceSize - freeSwapSpaceSize) / 0x100000L));
                break;
            }
            case "sqlExecTime": {
                double mean = (Double)JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.sql.execute,type=timers", (String)"Mean");
                double max1 = (Double)JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.sql.execute,type=timers", (String)"Max");
                data.put(MAX, (Object)max1);
                data.put("mean", (Object)mean);
                break;
            }
            case "webReqTime": {
                double webReqTime = (Double)JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.servletfilter.requestTimer,type=timers", (String)"Mean");
                data.put(VALUE, (Object)webReqTime);
                break;
            }
            case "dubboWaitTime": {
                data.put(VALUE, (Object)0);
                break;
            }
        }
        return data;
    }

    private static void fillData(CompositeDataSupport dataSupport, JSONObject result) {
        result.put(MAX, (Object)((Long)dataSupport.get(MAX) / 0x100000L));
        result.put(USED, (Object)((Long)dataSupport.get(USED) / 0x100000L));
        result.put(COMMITTED, (Object)((Long)dataSupport.get(COMMITTED) / 0x100000L));
    }

    static {
        try {
            memory = new ObjectName("java.lang:type=Memory");
            operatingSystem = new ObjectName("java.lang:type=OperatingSystem");
            memoryPoolMetaspace = new ObjectName("java.lang:type=MemoryPool,name=Metaspace");
            codeCache = new ObjectName("java.lang:type=MemoryPool,name=Code Cache");
            List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
                if (gcMxBean.getName().contains("G1")) {
                    gcType = "G1";
                    continue;
                }
                gcType = "default";
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

