/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.jmx;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.eye.api.armor.Grocery;
import kd.bos.eye.api.jmx.JMXRealtimeProvider;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.instance.Instance;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;

public class JmxHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String LOCAL_IP = NetAddressUtils.getLocalIpAddress();
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map params = ExchangeVueUtils.parseJsonFromPost(exchange, Map.class);
        JSONObject retData = new JSONObject();
        boolean history = (Boolean)params.get("history");
        boolean init = (Boolean)params.get("init");
        if (init || history) {
            JSONObject jsonObject = storage.queryMetrics(params);
            JSONObject instanceList = jsonObject.getJSONObject("instanceList");
            List<JSONObject> instanceStatus = this.getInstanceStatus(instanceList);
            retData.put("instanceStatus", instanceStatus);
            retData.putAll((Map)jsonObject);
        } else {
            List metrics = (List)params.get("metrics");
            HashMap<String, List<String>> listMap = new HashMap<String, List<String>>(32);
            ArrayList<String> localMetrics = new ArrayList<String>(8);
            for (String metric : metrics) {
                try {
                    String[] strings = metric.split("-");
                    String ip = strings[0];
                    if (ip.equals(LOCAL_IP)) {
                        localMetrics.add(strings[1]);
                        continue;
                    }
                    if (listMap.containsKey(ip)) {
                        ((List)listMap.get(ip)).add(metric);
                        continue;
                    }
                    ArrayList<String> objects = new ArrayList<String>(8);
                    objects.add(metric);
                    listMap.put(ip, objects);
                }
                catch (Exception e) {}
            }
            JSONObject metricsData = JMXRealtimeProvider.getMetrics(localMetrics);
            JSONObject remoteMetrics = this.getRemoteMetrics(listMap, params);
            retData.putAll((Map)metricsData);
            retData.putAll((Map)remoteMetrics);
        }
        ApiResponse<JSONObject> apiResponse = new ApiResponse<JSONObject>();
        apiResponse.setData(retData);
        apiResponse.setCode(0);
        this.writeJson(JSONUtils.toString(apiResponse), exchange);
    }

    private JSONObject getRemoteMetrics(Map<String, List<String>> params, Map<String, Object> originalParam) {
        JSONObject ret = new JSONObject();
        String instanceId = Instance.getInstanceId();
        try {
            CountDownLatch latch = new CountDownLatch(params.size());
            for (Map.Entry<String, List<String>> next : params.entrySet()) {
                String ip = next.getKey();
                ServiceInfo serviceInfo = this.getServiceInfoByIp(ip);
                if (serviceInfo != null && !instanceId.equals(serviceInfo.getInstanceId())) {
                    HashMap<String, Object> remoteParam = new HashMap<String, Object>(originalParam);
                    remoteParam.put("metrics", params.get(ip));
                    HashMap<String, Object> finalRemoteParam = remoteParam;
                    ThreadPools.executeOnce((String)"getMetrics", () -> {
                        try {
                            String result = Grocery.httpPost(ip, Integer.parseInt(serviceInfo.getMonitorPort()), JSONUtils.toString((Object)finalRemoteParam), "monitor/eye/metrics");
                            JSONObject jsonObject = JSONObject.parseObject((String)result);
                            ret.putAll((Map)jsonObject.getJSONObject("data"));
                        }
                        catch (Exception e) {
                            ret.put(ip, (Object)e.getMessage());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    continue;
                }
                List<String> value = next.getValue();
                for (String metric : value) {
                    ret.put(metric, (Object)"false");
                }
                latch.countDown();
            }
            boolean bl = latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ret.put("errorMessage", (Object)e.getMessage());
        }
        return ret;
    }

    private List<JSONObject> getInstanceStatus(JSONObject instanceMap) {
        String key;
        List serviceList = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo serviceInfo : serviceList) {
            String ip = serviceInfo.getIp();
            String appName = serviceInfo.getAppName();
            key = appName + "\n" + ip;
            instanceMap.put(key, (Object)"live");
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(16);
        Iterator iterator = instanceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            JSONObject item = new JSONObject();
            Map.Entry next = (Map.Entry)iterator.next();
            key = (String)next.getKey();
            String[] split = key.split("\n");
            item.put("id", (Object)split[1]);
            item.put("label", (Object)key);
            item.put("ip", (Object)split[1]);
            item.put("appName", (Object)split[0]);
            item.put("status", next.getValue());
            list.add(item);
        }
        list.sort(Comparator.comparing(o -> (String)o.get((Object)"id")));
        return list;
    }

    private ServiceInfo getServiceInfoByIp(String ip) {
        List serviceList = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo serviceInfo : serviceList) {
            if (!ip.equals(serviceInfo.getIp())) continue;
            return serviceInfo;
        }
        return null;
    }
}

