/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.jmx;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kd.bos.context.OperationContextCreator;
import org.apache.log4j.Logger;

public class JmxHttpAdapter {
    private static Logger log = Logger.getLogger(JmxHttpAdapter.class);

    public static void start() {
        OperationContextCreator.getOrCreateForBos();
        String s = JmxHttpAdapter.getProperty("JMX_HTTP_PORT", null);
        if (s == null) {
            return;
        }
        int port = Integer.parseInt(s);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        HtmlAdaptorServer adapter = new HtmlAdaptorServer();
        String user = System.getProperty("JMX_HTTP_ADMIN_USER");
        String password = System.getProperty("JMX_HTTP_ADMIN_PASSWORD");
        adapter.addUserAuthenticationInfo(new AuthInfo(user, password));
        try {
            ObjectName adapterName = new ObjectName("Server:name=HttpAdaptor");
            adapter.setPort(port);
            mbs.registerMBean(adapter, adapterName);
            adapter.start();
        }
        catch (Exception e) {
            log.error((Object)"Start jmx http adapter error.", (Throwable)e);
        }
        log.info((Object)"Jmx http adapter started.");
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

