/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.jmx.chart;

import java.util.Arrays;
import kd.bos.eye.api.jmx.chart.Chart;
import kd.bos.eye.api.jmx.chart.ChartProvider;
import kd.bos.eye.api.jmx.chart.Jmx;
import kd.bos.eye.api.jmx.chart.Serie;
import kd.bos.mservice.monitor.lang.LangRes;

public class ChartContents {
    private static final String HEAP_MEM_USAGE = "HeapMemoryUsage";

    public static ChartProvider getChartProvider() {
        return () -> Arrays.asList(ChartContents.createHeapChart(), ChartContents.createCpuChart());
    }

    private static Chart createCpuChart() {
        Chart chart = new Chart(LangRes.get((String)"ChartContents_0", (String)"CPU Load (%)", (Object[])new Object[0]), new Serie(new Jmx("java.lang:type=OperatingSystem", "ProcessCpuLoad", null)));
        chart.setYaxisFormatter("percent");
        return chart;
    }

    private static Chart createHeapChart() {
        Serie used = new Serie("used", new Jmx("java.lang:type=Memory", HEAP_MEM_USAGE, "used"));
        Serie committed = new Serie("committed", new Jmx("java.lang:type=Memory", HEAP_MEM_USAGE, "committed"));
        Serie max = new Serie("max", new Jmx("java.lang:type=Memory", HEAP_MEM_USAGE, "max"));
        Chart chart = new Chart(LangRes.get((String)"ChartContents_1", (String)"Heap Memory", (Object[])new Object[0]), max, committed, used);
        chart.setShowLegend(true);
        chart.setYaxisFormatter("mkb1024");
        return chart;
    }
}

