/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.limiter;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.limiter.entity.LimiterSceneInfo;
import kd.bos.eye.api.limiter.manager.LimiterSceneManager;
import kd.bos.eye.api.limiter.service.LimiterSceneService;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class LimiterSceneHandler
extends AbstractHttpHandler {
    private static final String PLACEHOLDER = "/ratelimiter/";
    private static final Log LOGGER = LogFactory.getLog(LimiterSceneHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    public static final String MONITOR_LIMITER_SCENE_TOTAL = "monitor.limiter.scene.total";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Object> response;
        block6: {
            response = new ApiResponse<Object>();
            response.setCode(-1);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            response.setData(map);
            URI uri = exchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(PLACEHOLDER);
            String endPoint = reqPath.substring(pos + PLACEHOLDER.length());
            Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
            try {
                if ("list".equals(endPoint)) {
                    this.queryLimiterList(exchange, map);
                    response.setCode(0);
                    break block6;
                }
                if ("add".equals(endPoint)) {
                    this.addLimiterList(exchange, response);
                    break block6;
                }
                if ("update".equals(endPoint)) {
                    this.updateLimiterList(exchange, response);
                    break block6;
                }
                if ("delete".equals(endPoint)) {
                    this.deleteLimiterList(exchange, params);
                    response.setCode(0);
                    break block6;
                }
                throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported actionType:" + endPoint});
            }
            catch (Throwable t) {
                LOGGER.error("limiterSceneException:{}", (Object)t.getMessage());
                response.setCode(-1);
                response.setMsg("limiterSceneException:" + t.getMessage());
            }
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void queryLimiterList(HttpExchange exchange, Map<String, Object> map) throws IOException {
        List<Map<String, Object>> limiterList = LimiterSceneService.queryLimiterList();
        map.put("limiterList", limiterList);
        int limiterTotal = Integer.parseInt(System.getProperty(MONITOR_LIMITER_SCENE_TOTAL, "1000"));
        map.put("limiterTotal", limiterTotal);
    }

    private void addLimiterList(HttpExchange exchange, ApiResponse<Object> response) throws IOException {
        LimiterSceneInfo limiterSceneInfo = ExchangeVueUtils.parseJsonFromPost(exchange, LimiterSceneInfo.class);
        this.checkNegative(limiterSceneInfo);
        if (LimiterSceneService.addLimiterList(limiterSceneInfo)) {
            String addLimiter = JSONUtils.toString((Object)limiterSceneInfo);
            LimiterSceneManager.getEyeConfigService().saveConfig("add", addLimiter);
            response.setCode(0);
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"LimiterSceneHandler_1", (String)"\u529f\u80fd\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"LimiterSceneHandler_3", (String)"\u65b0\u589e\u529f\u80fd\u9650\u6d41\u6570\u636e", (Object[])new Object[0]));
        }
    }

    private void updateLimiterList(HttpExchange exchange, ApiResponse<Object> response) throws IOException {
        LimiterSceneInfo limiterSceneInfo = ExchangeVueUtils.parseJsonFromPost(exchange, LimiterSceneInfo.class);
        this.checkNegative(limiterSceneInfo);
        if (LimiterSceneService.updateLimiterList(limiterSceneInfo)) {
            String updateLimiter = JSONUtils.toString((Object)limiterSceneInfo);
            LimiterSceneManager.getEyeConfigService().saveConfig("update", updateLimiter);
            response.setCode(0);
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"LimiterSceneHandler_1", (String)"\u529f\u80fd\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"LimiterSceneHandler_4", (String)"\u4fee\u6539\u529f\u80fd\u9650\u6d41\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]));
        }
    }

    private void deleteLimiterList(HttpExchange exchange, Map<String, String> params) throws IOException {
        String idStr = params.get("fid");
        if (StringUtils.isEmpty((String)idStr)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param fid can not be null!"});
        }
        if (LimiterSceneService.deleteLimiterList(idStr)) {
            LimiterSceneManager.getEyeConfigService().saveConfig("delete", idStr);
            OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"LimiterSceneHandler_1", (String)"\u529f\u80fd\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"LimiterSceneHandler_5", (String)"\u5220\u9664\u529f\u80fd\u9650\u6d41\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]));
        }
    }

    private void checkNegative(LimiterSceneInfo limiterSceneInfo) {
        String sceneCode = limiterSceneInfo.getSceneCode();
        if (!sceneCode.matches("^[a-zA-Z0-9_]+$")) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_6", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u573a\u666f\u7f16\u7801\u4e0d\u662f\u5b57\u6bcd\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u5408", (Object[])new Object[0])});
        }
        if (limiterSceneInfo.getId() == null && ConcurrentSceneManager.scenes.containsKey(sceneCode)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_7", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u573a\u666f\u7f16\u7801\u4e0d\u662f\u552f\u4e00", (Object[])new Object[0])});
        }
        if (!(!sceneCode.startsWith("TMP_TABLE") || "0".equals(limiterSceneInfo.getLimitType()) && "1".equals(limiterSceneInfo.getRange()) && "1".equals(limiterSceneInfo.getSingleUserLimit1()) && "0".equals(limiterSceneInfo.getTimeoutKillSql()))) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_8", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u4e34\u65f6\u8868\u9650\u6d41\u6570\u636e\u914d\u7f6e\u4e0d\u7b26\u5408\u89c4\u5219", (Object[])new Object[0])});
        }
        Long concurrency = limiterSceneInfo.getConcurrency();
        Long lockTimeout = limiterSceneInfo.getLockTimeout();
        Long slowTime = limiterSceneInfo.getSlowTime();
        Long duplicateWindowTime = limiterSceneInfo.getDuplicateWindowTime();
        if (concurrency == null || concurrency <= 0L) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_9", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u6700\u5927\u5e76\u53d1\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u4e3a\u8d1f\u6570", (Object[])new Object[0])});
        }
        if (lockTimeout == null || lockTimeout < 120L) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_10", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u5e76\u53d1\u9501\u5b9a\u8d85\u65f6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u5c0f\u4e8e120\u79d2", (Object[])new Object[0])});
        }
        if (slowTime == null || slowTime <= 0L) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_11", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u5b9a\u4e49\u6162\u64cd\u4f5c\u7684\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u4e3a\u8d1f\u6570", (Object[])new Object[0])});
        }
        if (duplicateWindowTime == null || duplicateWindowTime <= 0L) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_12", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u53bb\u91cd\u65f6\u95f4\u7a97\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u4e3a\u8d1f\u6570", (Object[])new Object[0])});
        }
        if (duplicateWindowTime > 3600L) {
            throw new KDException(BosErrorCode.bOS, new Object[]{LangRes.get((String)"LimiterSceneHandler_13", (String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u53bb\u91cd\u65f6\u95f4\u7a97\u53e3\u4e0d\u80fd\u5927\u4e8e1\u5c0f\u65f6", (Object[])new Object[0])});
        }
    }
}

