/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.limiter.manager;

import java.util.Iterator;
import java.util.Map;
import kd.bos.eye.api.limiter.entity.LimiterSceneInfo;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.limiter.impl.NodeConcurrencyLimiter;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.util.JSONUtils;

public class LimiterSceneManager {
    private static final Log log = LogFactory.getLog(LimiterSceneManager.class);
    private static final LimiterSceneChangeListener LISTENER = new LimiterSceneChangeListener();
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService("/runtime/monitor/config/limitConfig", scene -> {
            if ("initDataFromDB".equals(scene)) {
                ConcurrentSceneManager.init();
                return null;
            }
            if ("schedulePullDataFromDB".equals(scene)) {
                ConcurrentSceneManager.init();
                return null;
            }
            return null;
        }, LISTENER);
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static final class LimiterSceneChangeListener
    implements EyeConfigChangeListener {
        private LimiterSceneChangeListener() {
        }

        @Override
        public void configUpdate(String key, String value) {
            if ("add".equals(key)) {
                try {
                    LimiterSceneInfo addLimiter = (LimiterSceneInfo)JSONUtils.cast((String)value, LimiterSceneInfo.class);
                    ConcurrentScene concurrentScene = new ConcurrentScene();
                    concurrentScene.setFid(Long.parseLong(addLimiter.getId()));
                    concurrentScene.setSceneName(addLimiter.getSceneName());
                    concurrentScene.setSceneCode(addLimiter.getSceneCode());
                    concurrentScene.setSceneType(Integer.parseInt(addLimiter.getSceneType()));
                    concurrentScene.setLimitType(Integer.parseInt(addLimiter.getLimitType()));
                    concurrentScene.setRange(Integer.parseInt(addLimiter.getRange()));
                    concurrentScene.setTenantIsolation(addLimiter.getTenantIsolation().equals("1"));
                    concurrentScene.setConcurrency(addLimiter.getConcurrency().longValue());
                    concurrentScene.setLockTimeout(addLimiter.getLockTimeout().longValue());
                    concurrentScene.setTimeoutKillSQL(addLimiter.getTimeoutKillSql().equals("1"));
                    concurrentScene.setSingleUserLimit1(addLimiter.getSingleUserLimit1().equals("0"));
                    concurrentScene.setSlowThreshold(addLimiter.getSlowTime().longValue());
                    concurrentScene.setDuplicateWindowTime(addLimiter.getDuplicateWindowTime().longValue());
                    concurrentScene.setLimitEnable(addLimiter.getLimitEnable().equals("1"));
                    concurrentScene.setCreated(DateUtils.parseDateTime((String)addLimiter.getCreated(), (String)"yyyy-MM-dd HH:mm:ss"));
                    concurrentScene.setUpdated(addLimiter.getUpdated() == null ? null : DateUtils.parseDateTime((String)addLimiter.getUpdated(), (String)"yyyy-MM-dd HH:mm:ss"));
                    ConcurrentSceneManager.scenes.put(addLimiter.getSceneCode(), concurrentScene);
                    log.info("ConcurrentSceneManager add success, sceneCode = " + addLimiter.getSceneCode());
                }
                catch (Exception e) {
                    log.warn("ConcurrentSceneManager add error", (Throwable)e);
                }
            } else if ("update".equals(key)) {
                try {
                    LimiterSceneInfo updateLimiter = (LimiterSceneInfo)JSONUtils.cast((String)value, LimiterSceneInfo.class);
                    ConcurrentScene concurrentScene = new ConcurrentScene();
                    concurrentScene.setFid(Long.parseLong(updateLimiter.getId()));
                    concurrentScene.setSceneName(updateLimiter.getSceneName());
                    concurrentScene.setSceneCode(updateLimiter.getSceneCode());
                    concurrentScene.setSceneType(Integer.parseInt(updateLimiter.getSceneType()));
                    concurrentScene.setLimitType(Integer.parseInt(updateLimiter.getLimitType()));
                    concurrentScene.setRange(Integer.parseInt(updateLimiter.getRange()));
                    concurrentScene.setTenantIsolation(updateLimiter.getTenantIsolation().equals("1"));
                    concurrentScene.setConcurrency(updateLimiter.getConcurrency().longValue());
                    concurrentScene.setLockTimeout(updateLimiter.getLockTimeout().longValue());
                    concurrentScene.setTimeoutKillSQL(updateLimiter.getTimeoutKillSql().equals("1"));
                    concurrentScene.setSingleUserLimit1(updateLimiter.getSingleUserLimit1().equals("0"));
                    concurrentScene.setSlowThreshold(updateLimiter.getSlowTime().longValue());
                    concurrentScene.setDuplicateWindowTime(updateLimiter.getDuplicateWindowTime().longValue());
                    concurrentScene.setLimitEnable(updateLimiter.getLimitEnable().equals("1"));
                    concurrentScene.setCreated(DateUtils.parseDateTime((String)updateLimiter.getCreated(), (String)"yyyy-MM-dd HH:mm:ss"));
                    concurrentScene.setUpdated(updateLimiter.getUpdated() == null ? null : DateUtils.parseDateTime((String)updateLimiter.getUpdated(), (String)"yyyy-MM-dd HH:mm:ss"));
                    ConcurrentSceneManager.scenes.put(updateLimiter.getSceneCode(), concurrentScene);
                    if (updateLimiter.getLimitType().equals("0") && updateLimiter.getRange().equals("2")) {
                        NodeConcurrencyLimiter.updateCache((String)updateLimiter.getSceneCode(), (long)updateLimiter.getLockTimeout());
                    }
                    log.info("ConcurrentSceneManager update success, sceneCode = " + updateLimiter.getSceneCode());
                }
                catch (Exception e) {
                    log.warn("ConcurrentSceneManager update error", (Throwable)e);
                }
            } else if ("delete".equals(key)) {
                try {
                    Long id = Long.parseLong(value);
                    Iterator iterator = ConcurrentSceneManager.scenes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ConcurrentScene scene = (ConcurrentScene)entry.getValue();
                        if (!id.equals(scene.getFid())) continue;
                        log.info("ConcurrentSceneManager delete success, sceneCode = " + scene.getSceneCode());
                        iterator.remove();
                        break;
                    }
                }
                catch (Exception e) {
                    log.warn("ConcurrentSceneManager delete error", (Throwable)e);
                }
            }
        }
    }
}

