/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.limiter.service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.limiter.dao.LimiterSceneDao;
import kd.bos.eye.api.limiter.entity.LimiterScene;
import kd.bos.eye.api.limiter.entity.LimiterSceneInfo;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.Statement;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;

public class LimiterSceneService
extends LimiterSceneDao {
    public static List<Map<String, Object>> queryLimiterList() {
        ArrayList<Map<String, Object>> resultList = null;
        StringBuilder sb = new StringBuilder();
        String selectSql = LimiterSceneService.buildQuerySql("T_MONITOR_RATELIMITER_SCENE", LimiterScene.getAllFields(), null);
        sb.append(selectSql);
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), null));
            List returnList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<Map<String, Object>>(returnList.size());
            for (Result row : returnList) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                tempMap.put("id", row.getString("fid"));
                tempMap.put("sceneName", row.getString("fscene_name"));
                tempMap.put("sceneCode", row.getString("fscene_code"));
                tempMap.put("sceneType", row.getString("fscene_type"));
                tempMap.put("limitType", row.getString("flimit_type"));
                tempMap.put("range", row.getString("frange"));
                tempMap.put("tenantIsolation", row.getString("ftenant_isolation"));
                tempMap.put("concurrency", Long.parseLong(row.getString("fconcurrency")));
                tempMap.put("lockTimeout", Long.parseLong(row.getString("flock_timeout")));
                tempMap.put("timeoutKillSql", row.getString("ftimeout_kill_sql"));
                tempMap.put("singleUserLimit1", row.getString("fsingle_user_limit_1"));
                tempMap.put("slowTime", Long.parseLong(row.getString("fslow_time")));
                tempMap.put("duplicateWindowTime", Long.parseLong(row.getString("fduplicate_window_time")));
                tempMap.put("limitEnable", row.getString("flimit_enable"));
                String created = row.getString("fcreated");
                String updated = row.getString("fupdated");
                tempMap.put("created", created != null ? (created.contains(".") ? created.substring(0, created.indexOf(46)) : created) : null);
                tempMap.put("updated", updated != null ? (updated.contains(".") ? updated.substring(0, updated.indexOf(46)) : updated) : null);
                resultList.add(tempMap);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }

    public static boolean addLimiterList(LimiterSceneInfo limiterSceneInfo) {
        limiterSceneInfo.setId(String.valueOf(ID.genLongId()));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        limiterSceneInfo.setCreated(dtf.format(LocalDateTime.now()));
        try {
            DBRequest dbRequest = new DBRequest();
            Statement statement = MetadataFactory.getStatement();
            String insertSql = "insert into T_MONITOR_RATELIMITER_SCENE (fid,fscene_name,fscene_code,fscene_type,flimit_type,frange,ftenant_isolation,fconcurrency,flock_timeout,ftimeout_kill_sql,fsingle_user_limit_1,fslow_time,fduplicate_window_time,flimit_enable,fcreated,fupdated) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ArrayList insertList = new ArrayList(16);
            Collections.addAll(insertList, limiterSceneInfo.getId(), limiterSceneInfo.getSceneName(), limiterSceneInfo.getSceneCode(), limiterSceneInfo.getSceneType(), limiterSceneInfo.getLimitType(), limiterSceneInfo.getRange(), limiterSceneInfo.getTenantIsolation(), limiterSceneInfo.getConcurrency(), limiterSceneInfo.getLockTimeout(), limiterSceneInfo.getTimeoutKillSql(), limiterSceneInfo.getSingleUserLimit1(), limiterSceneInfo.getSlowTime(), limiterSceneInfo.getDuplicateWindowTime(), limiterSceneInfo.getLimitEnable(), limiterSceneInfo.getCreated(), limiterSceneInfo.getUpdated());
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
            return statement.executeInsert((Request)dbRequest) > 0;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    public static boolean updateLimiterList(LimiterSceneInfo limiterSceneInfo) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        limiterSceneInfo.setUpdated(dtf.format(LocalDateTime.now()));
        try {
            DBRequest dbRequest = new DBRequest();
            Statement statement = MetadataFactory.getStatement();
            String updateSql = "update T_MONITOR_RATELIMITER_SCENE set fscene_name=?,fscene_type=?,flimit_type=?,frange=?,ftenant_isolation=?,fconcurrency=?,flock_timeout=?,ftimeout_kill_sql=?,fsingle_user_limit_1=?,fslow_time=?,fduplicate_window_time=?,flimit_enable=?,fupdated=? where fid = ?";
            ArrayList updateList = new ArrayList(14);
            Collections.addAll(updateList, limiterSceneInfo.getSceneName(), limiterSceneInfo.getSceneType(), limiterSceneInfo.getLimitType(), limiterSceneInfo.getRange(), limiterSceneInfo.getTenantIsolation(), limiterSceneInfo.getConcurrency(), limiterSceneInfo.getLockTimeout(), limiterSceneInfo.getTimeoutKillSql(), limiterSceneInfo.getSingleUserLimit1(), limiterSceneInfo.getSlowTime(), limiterSceneInfo.getDuplicateWindowTime(), limiterSceneInfo.getLimitEnable(), limiterSceneInfo.getUpdated(), limiterSceneInfo.getId());
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            return statement.executeUpdate((Request)dbRequest) > 0;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    public static boolean deleteLimiterList(String id) {
        try {
            DBRequest dbRequest = new DBRequest();
            Statement statement = MetadataFactory.getStatement();
            String deleteSql = "delete from T_MONITOR_RATELIMITER_SCENE where fid = ?";
            ArrayList deleteList = new ArrayList(1);
            Collections.addAll(deleteList, id);
            dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
            return statement.executeDelete((Request)dbRequest) > 0;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }
}

