/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.localcache;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.LocalCacheMonitor;
import kd.bos.eye.api.armor.Grocery;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ServiceInfoManger;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class LocalCacheClearHandler
extends AbstractHttpHandler {
    private static final String instanceId = Instance.getInstanceId();
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        String LocalIp = NetAddressUtils.getLocalIpAddress();
        if (ConfigurationUtil.getBoolean((String)"monitor.localcache.clear.all", (Boolean)false).booleanValue()) {
            HashMap<String, String> msgMap = new HashMap<String, String>();
            Map<String, String> params = this.getParams(exchange, true);
            String instanceIdParam = params.get("instanceId");
            if (StringUtils.isEmpty((String)instanceIdParam)) {
                List serviceList = ServiceInfoManger.getInstance().getServiceList();
                for (ServiceInfo serviceInfo : serviceList) {
                    String id = serviceInfo.getInstanceId();
                    try {
                        if (instanceId.equals(id)) {
                            LocalCacheMonitor.clearAllLocalCache();
                        } else {
                            HashMap<String, String> remoterParam = new HashMap<String, String>();
                            String port = serviceInfo.getHostMonitorPort();
                            String ip = serviceInfo.getIp();
                            remoterParam.put("instanceId", id);
                            Grocery.httpPost(ip, Integer.parseInt(port), remoterParam, "/monitor/eye/clearAllLocalCache");
                        }
                        msgMap.put(id, "success");
                    }
                    catch (Exception e) {
                        msgMap.put(id, ExceptionHandler.getExceptionStackTrace(e));
                    }
                }
            } else if (instanceId.equals(instanceIdParam)) {
                LocalCacheMonitor.clearAllLocalCache();
            }
            response.setCode(0);
            response.setData(msgMap);
        } else {
            try {
                LocalCacheMonitor.clearAllLocalCache();
                response.setCode(0);
            }
            catch (Exception e) {
                response.setCode(1);
                response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
            }
        }
        OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"LocalCacheClearHandler_1", (String)"\u672c\u5730\u7f13\u5b58\u76d1\u63a7", (Object[])new Object[0]), LangRes.get((String)"LocalCacheClearHandler_2", (String)"\u6e05\u7406{0}\u8282\u70b9\u7684\u6240\u6709\u672c\u5730\u7f13\u5b58", (Object[])new Object[]{LocalIp}));
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

