/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.localcache;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.LocalCacheMonitor;
import kd.bos.cache.LocalCacheMonitorInfo;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;

public class LocalCacheInfoApiHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(LocalCacheInfoApiHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        String ip = NetAddressUtils.getLocalIpAddress();
        try {
            String cachekey = params.get("cachekey");
            String clearRegion = params.get("clearRegion");
            String clearType = params.get("clearType");
            if (clearRegion != null && clearType != null) {
                if (!EyeAuther.checkPermission(exchange, "localcacheinfo", "1")) {
                    throw new KDException("No permission!");
                }
                LocalCacheMonitor.clearCache((String)clearRegion, (String)clearType);
                OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"LocalCacheClearHandler_1", (String)"\u672c\u5730\u7f13\u5b58\u76d1\u63a7", (Object[])new Object[0]), LangRes.get((String)"LocalCacheClearHandler_3", (String)"\u6e05\u7406{0}\u8282\u70b9\u7684\u672c\u5730\u7f13\u5b58:{1}", (Object[])new Object[]{ip, clearRegion}));
            } else if (cachekey != null) {
                // empty if block
            }
            List data = LocalCacheMonitor.getCaches((String)cachekey);
            if (data.size() > 200) {
                data = data.subList(0, 200);
            }
            response.put("code", 0);
            response.put("data", data);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", "");
            response.put("msg", e.getMessage());
            logger.error((Throwable)e);
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void sortData(List<LocalCacheMonitorInfo> data, Map<String, String> params) {
        String orderField = params.get("orderField");
        String orderType = params.get("orderType");
        boolean isDesc = "descending".equals(orderType);
        if ("region".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null || o1.getRegion() == null || o2.getRegion() == null) {
                    return -1;
                }
                if (isDesc) {
                    return o2.getRegion().compareTo(o1.getRegion());
                }
                return o1.getRegion().compareTo(o2.getRegion());
            });
        } else if ("type".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null || o1.getType() == null || o2.getType() == null) {
                    return -1;
                }
                if (isDesc) {
                    return o2.getType().compareTo(o1.getType());
                }
                return o1.getType().compareTo(o2.getType());
            });
        } else if ("keysize".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (isDesc) {
                    return Long.compare(o2.getKeysize(), o1.getKeysize());
                }
                return Long.compare(o1.getKeysize(), o2.getKeysize());
            });
        } else if ("counts".equals(orderField)) {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (isDesc) {
                    return Integer.compare(o2.getCounts(), o1.getCounts());
                }
                return Integer.compare(o1.getCounts(), o2.getCounts());
            });
        } else {
            data.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                if (isDesc) {
                    return Long.compare(o2.getValuesize(), o1.getValuesize());
                }
                return Long.compare(o1.getValuesize(), o2.getValuesize());
            });
        }
    }
}

