/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.log.ESQueryBuilder;
import kd.bos.eye.api.log.LogObject;
import kd.bos.eye.api.log.LogQuery;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.api.log.QueryResult;
import kd.bos.util.StringUtils;

public class HttpESLogQuery
implements LogQuery {
    private static String SLOW_LOGGER_CLASSNAME = "kd.bos.slowlog.SlowLogger";
    private static List<String> columns = new ArrayList<String>(30);
    private static String default_columns = "appName,instanceId,appId,logtags.appId,level,line,ip,className,methodName,logtags.opKey,logtags.opMethod,logtags.formId,logtags.formName,message,message2,stacktrace,stacktrace2,time,logtags.traceId,logtags.tenantId,logtags.accountId,logtags.userId,logtags.userName,cost";

    @Override
    public int countLogQuery(Date begin, Date end, Map<String, String> queryFields) {
        try {
            LogQueryRequest logQueryRequest = new LogQueryRequest();
            ArrayList<String> time = new ArrayList<String>(2);
            SimpleDateFormat sdf = LogQueryUtils.getSimpleDateFormat();
            String startTimeStr = sdf.format(begin);
            String endTimeStr = sdf.format(end);
            time.add(startTimeStr);
            time.add(endTimeStr);
            logQueryRequest.setTime(time);
            logQueryRequest.setSize(0);
            logQueryRequest.setFrom(0);
            String queryJson = ESQueryBuilder.build(null, null, queryFields, begin, end, 0, 0);
            return LogQueryUtils.count(logQueryRequest, queryJson);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryResult query(String appName, String appId, String opKey, String opMethod, String formId, String formName, String className, String methodName, String instanceId, String traceId, String userId, String userName, String tenantId, String accountId, String level, int size, Date begin, Date end, String keyword, boolean slowLogger, String ip) {
        return this.query(appName, appId, opKey, opMethod, formId, formName, className, methodName, instanceId, traceId, userId, userName, tenantId, accountId, level, size, begin, end, keyword, slowLogger, "", ip, 0);
    }

    @Override
    public QueryResult query(String appName, String appId, String opKey, String opMethod, String formId, String formName, String className, String methodName, String instanceId, String traceId, String userId, String userName, String tenantId, String accountId, String level, int size, Date begin, Date end, String keyword, boolean slowLogger, String slowQueryType, String ip, int cost) {
        try {
            Map<String, String> queryFields = this.getQueryFieldsMap(appName, appId, opKey, opMethod, formId, formName, className, methodName, instanceId, traceId, userId, userName, tenantId, accountId, level, slowLogger, slowQueryType, ip, cost);
            String[] keywordFields = new String[]{"message", "stacktrace"};
            String[] keywords = StringUtils.split((String)this.escape(keyword), (boolean)true, (char[])new char[]{' '});
            String queryJson = ESQueryBuilder.build(keywords, keywordFields, queryFields, begin, end, size, 0);
            LogQueryRequest logQueryRequest = new LogQueryRequest();
            ArrayList<String> time = new ArrayList<String>(2);
            SimpleDateFormat sdf = LogQueryUtils.getSimpleDateFormat();
            String startTimeStr = sdf.format(begin);
            String endTimeStr = sdf.format(end);
            time.add(startTimeStr);
            time.add(endTimeStr);
            logQueryRequest.setTime(time);
            logQueryRequest.setSize(size);
            logQueryRequest.setFrom(0);
            return this.buildQueryResult(queryJson, LogQueryUtils.query(logQueryRequest, queryJson));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, String> getQueryFieldsMap(String appName, String appId, String opKey, String opMethod, String formId, String formName, String className, String methodName, String instanceId, String traceId, String userId, String userName, String tenantId, String accountId, String level, boolean slowLogger, String slowQueryType, String ip, int cost) {
        if (StringUtils.isEmpty((String)className) && slowLogger) {
            className = SLOW_LOGGER_CLASSNAME;
        }
        HashMap<String, String> queryFields = new HashMap<String, String>(8);
        if (!StringUtils.isEmpty((String)appName)) {
            queryFields.put("appName", this.escape(appName));
        }
        if (!StringUtils.isEmpty((String)appId)) {
            queryFields.put("logtags.appId", appId);
        }
        if (!StringUtils.isEmpty((String)opKey)) {
            queryFields.put("logtags.opKey", opKey);
        }
        if (!StringUtils.isEmpty((String)opMethod)) {
            queryFields.put("logtags.opMethod", opMethod);
        }
        if (!StringUtils.isEmpty((String)formId)) {
            queryFields.put("logtags.formId", formId);
        }
        if (!StringUtils.isEmpty((String)formName)) {
            queryFields.put("logtags.formName", formName);
        }
        if (!StringUtils.isEmpty((String)className)) {
            queryFields.put("className", className);
        }
        if (!StringUtils.isEmpty((String)methodName)) {
            queryFields.put("methodName", methodName);
        }
        if (!StringUtils.isEmpty((String)instanceId)) {
            queryFields.put("instanceId", this.escape(instanceId));
        }
        if (!StringUtils.isEmpty((String)traceId)) {
            queryFields.put("logtags.traceId", traceId);
        }
        if (!StringUtils.isEmpty((String)userId)) {
            queryFields.put("logtags.userId", userId);
        }
        if (!StringUtils.isEmpty((String)userName)) {
            queryFields.put("logtags.userName", userName);
        }
        if (!StringUtils.isEmpty((String)tenantId)) {
            queryFields.put("logtags.tenantId", this.escape(tenantId));
        }
        if (!StringUtils.isEmpty((String)accountId)) {
            queryFields.put("logtags.accountId", accountId);
        }
        if (!StringUtils.isEmpty((String)level)) {
            queryFields.put("level", level);
        }
        if (!StringUtils.isEmpty((String)ip)) {
            queryFields.put("ip", ip);
        }
        if (!StringUtils.isEmpty((String)slowQueryType)) {
            queryFields.put("slowQueryType", slowQueryType);
        }
        if (cost > 0) {
            queryFields.put("cost", String.valueOf(cost));
        }
        return queryFields;
    }

    private QueryResult buildQueryResult(String requestJson, String responseJson) {
        ArrayList<LogObject> logList = new ArrayList();
        try {
            logList = LogQueryUtils.jsonToListObject(responseJson, columns);
        }
        catch (Exception e) {
            return new QueryResult(-1, e.getMessage());
        }
        QueryResult qr = new QueryResult(logList);
        qr.postData = requestJson;
        return qr;
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString().trim().replace(" ", "");
    }

    static {
        columns.addAll(Arrays.asList(default_columns.split(",")));
    }
}

