/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.eye.api.log.datasource.LogDataSourceInfo;
import kd.bos.eye.api.log.datasource.LogDataSourceManager;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.util.JSONUtils;

public class LogDatasourceHandler
extends AbstractHttpHandler {
    public static final String VALUE_STR = "value";
    public static final String LABEL_STR = "label";

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            ArrayList datasource = new ArrayList(4);
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            List<LogDataSourceInfo> logDataSourceInfos = LogDataSourceManager.getMuiltDataSources();
            for (LogDataSourceInfo logDataSourceInfo : logDataSourceInfos) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(VALUE_STR, logDataSourceInfo.getNumber());
                map.put(LABEL_STR, logDataSourceInfo.getName());
                datasource.add(map);
            }
            if (!logDataSourceInfos.isEmpty()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(VALUE_STR, "AllDataSourceQuery");
                map.put(LABEL_STR, "ALL");
                datasource.add(map);
                data.put("default", "AllDataSourceQuery");
            }
            data.put("datasource", datasource);
            data.put("logKeywordEncryptEnable", this.logKeywordEncryptEnable());
            response.setData(data);
            response.setCode(0);
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    public boolean logKeywordEncryptEnable() {
        boolean logKeywordEncryptEnable = Boolean.parseBoolean(System.getProperty("monitor.log.keyword.encrypt.enable", "true"));
        return logKeywordEncryptEnable;
    }
}

