/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.api.log.old.LogObject;
import kd.bos.eye.api.log.old.LogQuery;
import kd.bos.eye.api.log.old.LogQueryFactory;
import kd.bos.eye.api.log.old.QueryResult;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.JSONUtils;

public class LogQueryHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        try {
            String aTrue;
            boolean parseBoolean;
            String decodedKeyword;
            LogQueryRequest req = (LogQueryRequest)ExchangeVueUtils.parsePostJson(exchange, LogQueryRequest.class);
            if (Boolean.parseBoolean(System.getProperty("monitor.log.keyword.encrypt.enable", "true")) && (decodedKeyword = req.getKeyword()) != null && !decodedKeyword.isEmpty()) {
                decodedKeyword = this.base64Decode(decodedKeyword);
                req.setKeyword(decodedKeyword);
            }
            JSONArray result = (parseBoolean = Boolean.parseBoolean(aTrue = System.getProperty("monitor.log.query.new", "true"))) ? LogQueryUtils.jsonToDataArray(LogQueryUtils.query(req)) : this.getData(req);
            response.put("data", result);
            response.put("code", 0);
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("msg", ExceptionHandler.getExceptionStackTrace(e));
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private JSONArray getData(LogQueryRequest req) throws ParseException {
        SimpleDateFormat simpleDateFormat = LogQueryUtils.getSimpleDateFormat();
        List<String> time = req.getTime();
        LogQuery query = LogQueryFactory.getLogQuery();
        Calendar instance = Calendar.getInstance();
        instance.setTime(simpleDateFormat.parse(time.get(0)));
        instance.add(11, 8);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(time.get(1)));
        calendar.add(11, 8);
        QueryResult results = query.query(req.getAppName(), req.getAppId(), req.getOpKey(), req.getOpMethod(), req.getFormId(), req.getFormName(), req.getClassName(), req.getMethodName(), req.getInstanceId(), req.getTraceId(), req.getUserID(), req.getUserName(), req.getTenantId(), req.getAccountId(), req.getLevel(), req.getSize(), 0, 0, req.getKeyword(), String.valueOf(req.isSlowQuery()), true, instance.getTime(), calendar.getTime());
        return this.formatResult(results.getData());
    }

    private JSONArray formatResult(List<LogObject> list) {
        JSONArray array = new JSONArray();
        for (LogObject logObject : list) {
            JSONObject logtags = new JSONObject();
            logtags.put("traceId", (Object)logObject.getTraceId());
            logtags.put("accountId", (Object)logObject.getAccountId());
            logtags.put("appId", (Object)logObject.getAppId());
            logtags.put("tenantId", (Object)logObject.getTenantId());
            logtags.put("orgId", (Object)"");
            logtags.put("userName", (Object)logObject.getUserName());
            logtags.put("userId", (Object)logObject.getUserId());
            logtags.put("opKey", (Object)logObject.getOpKey());
            logtags.put("opMethod", (Object)logObject.getOpMethod());
            logtags.put("formId", (Object)logObject.getFormId());
            logtags.put("formName", (Object)logObject.getFormName());
            JSONObject retObj = new JSONObject();
            retObj.put("clusterName", (Object)logObject.getClassName());
            retObj.put("instanceId", (Object)logObject.getInstanceId());
            retObj.put("appName", (Object)logObject.getAppName());
            retObj.put("time", (Object)logObject.getTime());
            retObj.put("ip", (Object)logObject.getIp());
            retObj.put("className", (Object)logObject.getClassName());
            retObj.put("methodName", (Object)logObject.getMethodName());
            retObj.put("line", (Object)logObject.getLine());
            retObj.put("level", (Object)logObject.getLevel());
            retObj.put("message", (Object)logObject.getMessage());
            retObj.put("message2", (Object)logObject.getMessage2());
            retObj.put("stacktrace", (Object)logObject.getStacktrace());
            retObj.put("stacktrace2", (Object)logObject.getStacktrace2());
            retObj.put("logtags", (Object)logtags);
            array.add((Object)retObj);
        }
        return array;
    }

    public static String getClassMethodLine(LogObject log) {
        return log.getClassName() + "\r\n" + log.getMethodName() + "(" + log.getLine() + "):" + log.getLevel();
    }

    public static String getMessage(LogObject log) {
        String message = log.getMessage();
        String message2 = log.getMessage2();
        if (message == null) {
            return message2;
        }
        if (message2 != null) {
            return message + message2;
        }
        return message;
    }

    private String base64Decode(String encoded) {
        byte[] decodedBytes = Base64.getDecoder().decode(encoded);
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }
}

