/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.log.LogObject;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.QueryParamBuilder;
import kd.bos.eye.api.log.datasource.LogDataSourceInfo;
import kd.bos.eye.api.log.datasource.LogDataSourceManager;
import kd.bos.util.StringUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

public class LogQueryUtils {
    public static final String TOTAL = "total";
    public static final String LOGTAGS = "logtags";
    public static final String SOURCE = "_source";
    public static final String HITS = "hits";
    public static final String MESSAGE_2 = "message2";
    public static final String MESSAGE = "message";
    public static final String TIME = "time";
    public static final String LOGID = "logid";
    public static final String ID = "_id";
    public static final String EMPTY_STR = "";
    public static final String TIMESTAMP_1 = "@timestamp";
    public static final String TIMESTAMP = "timestamp";
    public static final String FORMAT_PARRERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static Map<String, Integer> esServerMap = new HashMap<String, Integer>(2);
    private static final String ES_CERTIFICATE_PATH = "monitor.es.certificate.path";
    private static final String ES_CERTIFICATE_PD = "monitor.es.certificate.password";
    private static final String ES_HTTP_CONNECTION_TIMEOUT = "monitor.es.connection.timeout";
    private static final String ES_HTTP_SOCKET_CONNECTION_TIMEOUT = "monitor.es.socket.connection.timeout";
    private static final String HTTPS_SCHEMA = "https";
    private static final String HTTP_SCHEMA = "http";
    private static KeyStore trustStore;

    public static String query(LogQueryRequest logQueryRequest) throws IOException {
        LogQueryUtils.checkParams(logQueryRequest, null);
        return LogQueryUtils.query(logQueryRequest, QueryParamBuilder.build(logQueryRequest).builder());
    }

    public static String query(LogQueryRequest logQueryRequest, String queryJson) throws IOException {
        LogQueryUtils.checkParams(logQueryRequest, queryJson);
        String dataSourceNumber = logQueryRequest.getDatasource();
        List<LogDataSourceInfo> logDataSourceInfos = LogDataSourceManager.getDataSourcesByNumber(dataSourceNumber);
        if (LogQueryUtils.isSameEsService(logDataSourceInfos)) {
            ArrayList<String> indexPrefixes = new ArrayList<String>(1);
            for (LogDataSourceInfo info : logDataSourceInfos) {
                indexPrefixes.add(info.getIndex());
            }
            LogDataSourceInfo info0 = logDataSourceInfos.get(0);
            String url = LogQueryUtils.getUrl(info0.getUrl(), LogQueryUtils.getIndices(logQueryRequest.getTime().get(0), logQueryRequest.getTime().get(1), indexPrefixes.toArray(new String[0])));
            return LogQueryUtils.excutePost(LogQueryUtils.createHttpClient(info0), url, queryJson);
        }
        JSONObject resultJsonObject = new JSONObject();
        int querySize = logQueryRequest.getSize();
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>(querySize);
        for (LogDataSourceInfo info : logDataSourceInfos) {
            String url = LogQueryUtils.getUrl(info.getUrl(), LogQueryUtils.getIndices(logQueryRequest.getTime().get(0), logQueryRequest.getTime().get(1), info.getIndex()));
            String responseJson = LogQueryUtils.excutePost(LogQueryUtils.createHttpClient(info), url, queryJson);
            JSONObject jsonObject = JSONObject.parseObject((String)responseJson);
            JSONArray arrays = jsonObject.getJSONObject(HITS).getJSONArray(HITS);
            int arraySize = arrays.size();
            for (int i = 0; i < arraySize; ++i) {
                dataList.add(arrays.getJSONObject(i));
            }
            int dataSize = dataList.size();
            if (dataSize > querySize) {
                LogQueryUtils.sort(dataList);
                for (int j = querySize; j < dataSize; ++j) {
                    dataList.remove(querySize);
                }
            }
            resultJsonObject = jsonObject;
        }
        LogQueryUtils.sort(dataList);
        JSONArray dataJsonArray = new JSONArray();
        dataJsonArray.addAll(dataList);
        resultJsonObject.getJSONObject(HITS).put(HITS, (Object)dataJsonArray);
        return resultJsonObject.toString();
    }

    private static void sort(List<JSONObject> dataList) {
        final SimpleDateFormat sdf = LogQueryUtils.getSimpleDateFormat();
        dataList.sort(new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                try {
                    JSONObject source1 = o1.getJSONObject(LogQueryUtils.SOURCE);
                    JSONObject source2 = o2.getJSONObject(LogQueryUtils.SOURCE);
                    String timeStr1 = source1.getString(LogQueryUtils.TIMESTAMP_1);
                    String timeStr2 = source2.getString(LogQueryUtils.TIMESTAMP_1);
                    if (timeStr1 != null && timeStr2 != null) {
                        Date d1 = sdf.parse(timeStr1);
                        Date d2 = sdf.parse(timeStr2);
                        return d2.compareTo(d1);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }

    public static int count(LogQueryRequest logQueryRequest) throws IOException {
        LogQueryUtils.checkParams(logQueryRequest, null);
        return LogQueryUtils.count(logQueryRequest, QueryParamBuilder.build(logQueryRequest).builder());
    }

    public static int count(LogQueryRequest logQueryRequest, String queryJson) throws IOException {
        LogQueryUtils.checkParams(logQueryRequest, queryJson);
        int total = 0;
        String dataSourceNumber = logQueryRequest.getDatasource();
        List<LogDataSourceInfo> logDataSourceInfos = LogDataSourceManager.getDataSourcesByNumber(dataSourceNumber);
        if (LogQueryUtils.isSameEsService(logDataSourceInfos)) {
            ArrayList<String> indexPrefixes = new ArrayList<String>(1);
            for (LogDataSourceInfo info : logDataSourceInfos) {
                indexPrefixes.add(info.getIndex());
            }
            LogDataSourceInfo info0 = logDataSourceInfos.get(0);
            String url = LogQueryUtils.getUrl(info0.getUrl(), LogQueryUtils.getIndices(logQueryRequest.getTime().get(0), logQueryRequest.getTime().get(1), indexPrefixes.toArray(new String[0])));
            String response = LogQueryUtils.excutePost(LogQueryUtils.createHttpClient(info0), url, queryJson);
            JSONObject js = JSONObject.parseObject((String)response);
            total = LogQueryUtils.getTotal(js, info0.getUrl());
        } else {
            for (LogDataSourceInfo info : logDataSourceInfos) {
                String url = LogQueryUtils.getUrl(info.getUrl(), LogQueryUtils.getIndices(logQueryRequest.getTime().get(0), logQueryRequest.getTime().get(1), info.getIndex()));
                String response = LogQueryUtils.excutePost(LogQueryUtils.createHttpClient(info), url, queryJson);
                JSONObject js = JSONObject.parseObject((String)response);
                total += LogQueryUtils.getTotal(js, info.getUrl());
            }
        }
        return total;
    }

    public static JSONArray jsonToDataArray(String responseJson) {
        JSONObject resource = JSONObject.parseObject((String)responseJson);
        SimpleDateFormat dateFormat = LogQueryUtils.getPageViewSdf();
        SimpleDateFormat simpleDateFormat = LogQueryUtils.getSimpleDateFormatUTC();
        JSONArray ret = new JSONArray();
        JSONArray arrays = resource.getJSONObject(HITS).getJSONArray(HITS);
        int size = arrays.size();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject hit = arrays.getJSONObject(i);
                JSONObject source = hit.getJSONObject(SOURCE);
                JSONObject logtags = source.getJSONObject(LOGTAGS);
                if (logtags == null) {
                    source.put(LOGTAGS, (Object)EMPTY_STR);
                }
                String message = source.getString(MESSAGE);
                String message2 = source.getString(MESSAGE_2);
                if (!StringUtils.isEmpty((String)message)) {
                    source.put(MESSAGE, (Object)LogQueryUtils.cleanXss(message));
                }
                if (!StringUtils.isEmpty((String)message2)) {
                    source.put(MESSAGE_2, (Object)LogQueryUtils.cleanXss(message2));
                }
                source.put(TIME, (Object)dateFormat.format(simpleDateFormat.parse(source.getString(TIME))));
                ret.add((Object)source);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static List<LogObject> jsonToListObject(String responseJson, List<String> columns) throws ParseException, IllegalAccessException, InvocationTargetException {
        ArrayList<LogObject> logList = new ArrayList<LogObject>(8);
        JSONObject js = JSONObject.parseObject((String)responseJson);
        JSONArray hits = js.getJSONObject(HITS).getJSONArray(HITS);
        if (hits != null && !hits.isEmpty()) {
            for (Object obj : hits) {
                JSONObject hit = (JSONObject)obj;
                JSONObject o = hit.getJSONObject(SOURCE);
                HashMap<String, Object> log = new HashMap<String, Object>();
                log.put(LOGID, hit.get((Object)ID));
                for (String col : columns) {
                    int pos = col.indexOf(46);
                    if (pos < 0) {
                        log.put(col, o.get((Object)col));
                        continue;
                    }
                    String key = col.substring(0, pos);
                    JSONObject json = o.getJSONObject(key);
                    String tagkey = col.substring(pos + 1);
                    String value = json != null ? json.get((Object)tagkey) : EMPTY_STR;
                    log.put(tagkey, value);
                }
                log.put(TIMESTAMP, LogQueryUtils.getPageViewSdf().format(LogQueryUtils.getSimpleDateFormatUTC().parse(o.get((Object)TIMESTAMP_1).toString())));
                LogObject logObj = new LogObject();
                BeanUtils.populate((Object)logObj, log);
                logObj.setTime(LogQueryUtils.getPageViewSdf().format(LogQueryUtils.getSimpleDateFormatUTC().parse((String)log.get(TIME))));
                logList.add(logObj);
            }
        }
        return logList;
    }

    private static String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }

    public static int getMaxRange() {
        return Integer.getInteger("monitor.log.maxSearchRange", 5);
    }

    private static SimpleDateFormat getSimpleDateFormatUTC() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_PARRERN);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public static SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_PARRERN);
        return simpleDateFormat;
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(FORMAT_PARRERN);
    }

    private static SimpleDateFormat getPageViewSdf() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static void checkParams(LogQueryRequest logQueryRequest, String queryJson) {
        if (logQueryRequest == null) {
            throw new KDException("The param logQueryRequest can not be null!");
        }
        List<String> times = logQueryRequest.getTime();
        if (times == null || times.isEmpty()) {
            throw new KDException("The param logQueryRequest.time field can not be Empty!");
        }
        if (times.size() < 2) {
            throw new KDException("The param logQueryRequest.time field error,startTime or endTime can not be null!");
        }
    }

    private static String excutePost(HttpClient client, String url, String params) throws IOException {
        HttpPost post = new HttpPost(url);
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Integer.parseInt(System.getProperty(ES_HTTP_CONNECTION_TIMEOUT, "300000"))).setSocketTimeout(Integer.parseInt(System.getProperty(ES_HTTP_SOCKET_CONNECTION_TIMEOUT, "300000"))).build();
            post.setConfig(requestConfig);
            StringEntity se = new StringEntity(params, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                String string = LogQueryUtils.asJson(resEntity);
                return string;
            }
            throw new IOException("Can't access elastic, status:" + response.getStatusLine() + ", detail:" + response);
        }
        finally {
            post.releaseConnection();
            if (client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
    }

    private static String asJson(HttpEntity resEntity) throws IOException {
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            StringBuilder sb = new StringBuilder();
            try (InputStream in = gzipEntity.getContent();
                 InputStreamReader its = new InputStreamReader(in);
                 BufferedReader br = new BufferedReader(its);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            return sb.toString();
        }
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    private static HttpClient createHttpClient(LogDataSourceInfo logDataSourceInfo) {
        CloseableHttpClient client;
        String username = logDataSourceInfo.getUs();
        String password = logDataSourceInfo.getPp();
        Boolean isSslEnable = logDataSourceInfo.isSslEnable();
        if (username != null && password != null) {
            password = Encrypters.decode((String)password);
            logDataSourceInfo.setPp(password);
            client = isSslEnable.booleanValue() ? LogQueryUtils.createHttpsClient(logDataSourceInfo) : HttpClients.custom().setDefaultCredentialsProvider(LogQueryUtils.initCreadentials(username, password)).build();
        } else {
            client = HttpClients.createDefault();
        }
        LogQueryUtils.initESServerVersion(logDataSourceInfo, (HttpClient)client);
        return client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CloseableHttpClient createHttpsClient(LogDataSourceInfo logDataSourceInfo) {
        Asserts.notNull((Object)trustStore, (String)"trustStore");
        String username = logDataSourceInfo.getUs();
        String password = logDataSourceInfo.getPp();
        String path = logDataSourceInfo.getCertificatePath();
        if (StringUtils.isEmpty((String)path)) {
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS_SCHEMA, (Object)sslsf).register(HTTP_SCHEMA, (Object)new PlainConnectionSocketFactory()).build();
                BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
                CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider(LogQueryUtils.initCreadentials(username, password)).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                LogQueryUtils.initESServerVersion(logDataSourceInfo, (HttpClient)client);
                return client;
            }
            catch (Exception e) {
                throw new KDException(e);
            }
        }
        String certificatePwd = logDataSourceInfo.getCertificatePP();
        if (certificatePwd == null) {
            throw new KDException("Certificate password cann't be null when use SSL/TLS, please config: monitor.es.certificate.password");
        }
        try (FileInputStream is = new FileInputStream(FilenameUtils.normalize((String)path));){
            trustStore.load(is, certificatePwd.toCharArray());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS_SCHEMA, (Object)sslsf).register(HTTP_SCHEMA, (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider(LogQueryUtils.initCreadentials(username, password)).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            LogQueryUtils.initESServerVersion(logDataSourceInfo, (HttpClient)client);
            CloseableHttpClient closeableHttpClient = client;
            return closeableHttpClient;
        }
        catch (Exception e) {
            throw new KDException(e);
        }
    }

    private static CredentialsProvider initCreadentials(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    private static String getIndices(String start, String end, String ... indexPrefixs) {
        SimpleDateFormat sdfUTC = LogQueryUtils.getSimpleDateFormatUTC();
        int max_range = LogQueryUtils.getMaxRange();
        ArrayList<String> indices = new ArrayList<String>(1);
        for (String indexPrefix : indexPrefixs) {
            CharSequence[] indexArr;
            TreeSet<String> betweenTime = new TreeSet<String>();
            SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date startTime = sdfUTC.parse(start);
                Date endTime = sdfUTC.parse(end);
                Calendar sCalendar = Calendar.getInstance();
                sCalendar.setTime(startTime);
                int year = sCalendar.get(1);
                int month = sCalendar.get(2);
                int day = sCalendar.get(5);
                sCalendar.set(year, month, day, 0, 0, 0);
                Calendar eCalendar = Calendar.getInstance();
                eCalendar.setTime(endTime);
                year = eCalendar.get(1);
                month = eCalendar.get(2);
                day = eCalendar.get(5);
                eCalendar.set(year, month, day, 0, 0, 0);
                String[] split = indexPrefix.trim().split(",");
                while (sCalendar.before(eCalendar)) {
                    int n = split.length;
                    for (int i = 0; i < n; ++i) {
                        betweenTime.add(split[i] + outFormat.format(sCalendar.getTime()));
                    }
                    sCalendar.add(6, 1);
                }
                for (String pre : split) {
                    betweenTime.add(pre + outFormat.format(eCalendar.getTime()));
                }
                int size = betweenTime.size() > max_range ? max_range : betweenTime.size();
                indexArr = new String[size];
                for (int i = 0; i < size; ++i) {
                    indexArr[i] = (String)betweenTime.pollLast();
                }
            }
            catch (Exception e) {
                indexArr = new String[]{indexPrefix + outFormat.format(System.currentTimeMillis())};
            }
            indices.add(String.join((CharSequence)",", indexArr));
        }
        return String.join((CharSequence)",", indices);
    }

    private static String getUrl(String esUrl, String indices) {
        if (StringUtils.isEmpty((String)esUrl)) {
            throw new NullPointerException("monitor url is null");
        }
        if (!esUrl.endsWith("/")) {
            esUrl = esUrl + "/";
        }
        return esUrl + indices + "/_search?ignore_unavailable=true&allow_no_indices=true";
    }

    private static boolean isSameEsService(List<LogDataSourceInfo> logDataSourceInfos) {
        int size = logDataSourceInfos.size();
        if (size < 1) {
            return true;
        }
        LogDataSourceInfo info0 = logDataSourceInfos.get(0);
        for (int i = 1; i < size; ++i) {
            LogDataSourceInfo info = logDataSourceInfos.get(i);
            if (LogQueryUtils.equals(info0.getUrl(), info.getUrl()) && LogQueryUtils.equals(info0.getUs(), info.getUs()) && LogQueryUtils.equals(info0.getPp(), info.getPp()) && LogQueryUtils.equals(info0.getCertificatePath(), info.getCertificatePath()) && LogQueryUtils.equals(info0.getCertificatePP(), info.getCertificatePP())) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object obj1, Object obj2) {
        boolean same = Objects.equals(obj1, obj2);
        if (!same) {
            obj1 = LogQueryUtils.unwrapObjectToCompare(obj1);
            obj2 = LogQueryUtils.unwrapObjectToCompare(obj2);
            same = Objects.equals(obj1, obj2);
        }
        return same;
    }

    private static Object unwrapObjectToCompare(Object obj) {
        if (obj instanceof Date) {
            obj = ((Date)obj).getTime();
        } else if (obj instanceof Number) {
            double v1 = ((Number)obj).doubleValue();
            long v2 = ((Number)obj).longValue();
            return v1;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initESServerVersion(LogDataSourceInfo logDataSourceInfo, HttpClient client) {
        Integer esServerVersion = esServerMap.get(logDataSourceInfo.getUrl());
        if (esServerVersion == null) {
            HttpGet request = new HttpGet(logDataSourceInfo.getUrl());
            try {
                HttpResponse response = client.execute((HttpUriRequest)request);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() == 200) {
                    HttpEntity resEntity = response.getEntity();
                    JSONObject responseJson = JSONObject.parseObject((String)LogQueryUtils.asJson(resEntity));
                    JSONObject version = responseJson.getJSONObject("version");
                    String number = version.getString("number");
                    String[] versions = number.trim().split("\\.");
                    esServerMap.put(logDataSourceInfo.getUrl(), Integer.parseInt(versions[0]));
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                request.releaseConnection();
            }
        }
    }

    private static int getTotal(JSONObject responseJson, String url) {
        JSONObject hits = responseJson.getJSONObject(HITS);
        Integer version = esServerMap.get(url);
        if (version == null) {
            try {
                return hits.getIntValue(TOTAL);
            }
            catch (Exception e) {
                return hits.getJSONObject(TOTAL).getIntValue("value");
            }
        }
        if (version <= 6) {
            return hits.getIntValue(TOTAL);
        }
        return hits.getJSONObject(TOTAL).getIntValue("value");
    }

    static {
        try {
            trustStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            trustStore = null;
        }
    }
}

