/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.StringUtils;

public class QueryLogHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        SimpleDateFormat sdf = LogQueryUtils.getSimpleDateFormat();
        Map<String, String> map = ExchangeVueUtils.parseParameters(exchange);
        String traceId = map.get("traceId");
        if (StringUtils.isEmpty((String)traceId)) {
            this.ofResponse(-1, "traceId is null", null);
            this.writeJson(this.ofResponse(-1, "traceId is null", null), exchange);
            return;
        }
        try {
            LogQueryRequest queryRequest = new LogQueryRequest();
            ArrayList<String> times = new ArrayList<String>();
            Calendar instance = Calendar.getInstance();
            instance.add(5, -1);
            Date date = instance.getTime();
            times.add(sdf.format(date));
            times.add(sdf.format(new Date()));
            queryRequest.setTraceId(traceId);
            queryRequest.setTime(times);
            String size = map.get("size");
            if (StringUtils.isNotEmpty((String)size)) {
                int count = Integer.parseInt(size);
                queryRequest.setSize(count > 5000 ? 5000 : count);
            } else {
                queryRequest.setSize(100);
            }
            RequestContext requestContext = RequestContext.get();
            if (requestContext != null) {
                queryRequest.setAccountId(requestContext.getAccountId());
                queryRequest.setTenantId(requestContext.getTenantId());
            }
            JSONArray result = LogQueryUtils.jsonToDataArray(LogQueryUtils.query(queryRequest));
            this.writeJson(this.ofResponse(0, "", QueryLogHandler.formatResult(result)), exchange);
        }
        catch (Exception e) {
            this.writeJson(this.ofResponse(-1, ExceptionHandler.getExceptionStackTrace(e), null), exchange);
        }
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private String ofResponse(int status, String message, Object data) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)status);
        result.put("message", (Object)message);
        result.put("data", data);
        return result.toJSONString();
    }

    private static JSONArray formatResult(JSONArray arrays) {
        JSONArray ret = new JSONArray();
        int size = arrays.size();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject retObj = new JSONObject();
                JSONObject source = arrays.getJSONObject(i);
                JSONObject logtags = source.getJSONObject("logtags");
                if (logtags != null) {
                    retObj.put("traceId", (Object)logtags.getString("traceId"));
                    retObj.put("accountId", (Object)logtags.getString("accountId"));
                    retObj.put("appId", (Object)logtags.getString("appId"));
                    retObj.put("tenantId", (Object)logtags.getString("tenantId"));
                    retObj.put("orgId", (Object)logtags.getString("orgId"));
                    retObj.put("userName", (Object)logtags.getString("userName"));
                    retObj.put("userId", (Object)logtags.getString("userId"));
                    retObj.put("opKey", (Object)logtags.getString("opKey"));
                    retObj.put("opMethod", (Object)logtags.getString("opMethod"));
                    retObj.put("formId", (Object)logtags.getString("formId"));
                    retObj.put("formName", (Object)logtags.getString("formName"));
                }
                retObj.put("clusterName", (Object)source.getString("clusterName"));
                retObj.put("instanceId", (Object)source.getString("instanceId"));
                retObj.put("appName", (Object)source.getString("appName"));
                retObj.put("time", (Object)source.getString("time"));
                retObj.put("ip", (Object)source.getString("ip"));
                retObj.put("className", (Object)source.getString("className"));
                retObj.put("methodName", (Object)source.getString("methodName"));
                retObj.put("line", (Object)source.getString("line"));
                retObj.put("level", (Object)source.getString("level"));
                String message = source.getString("message");
                String message2 = source.getString("message2");
                String stacktrace = source.getString("stacktrace");
                String stacktrace2 = source.getString("stacktrace2");
                if (StringUtils.isNotEmpty((String)message2)) {
                    message = message + message2;
                }
                if (StringUtils.isNotEmpty((String)stacktrace)) {
                    message = message + stacktrace;
                }
                if (StringUtils.isNotEmpty((String)stacktrace2)) {
                    message = message + stacktrace2;
                }
                retObj.put("message", (Object)message);
                ret.add((Object)retObj);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }
}

