/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import java.util.List;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class QueryParamBuilder {
    private static final String SLOW_LOGGER_CLASSNAME = "kd.bos.slowlog.SlowLogger";
    private static final String KEYWORD = ".keyword";
    private static final String LOG_TAGS = "logtags.";
    private LogQueryRequest queryRequest;

    private QueryParamBuilder(LogQueryRequest queryRequest) {
        this.queryRequest = queryRequest;
    }

    public static QueryParamBuilder build(LogQueryRequest queryRequest) {
        return new QueryParamBuilder(queryRequest);
    }

    public String builder() {
        String keyword = Boolean.parseBoolean(System.getProperty("monitor.log.query.enableKeyword", "true")) ? KEYWORD : "";
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)this.queryRequest.getAppName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("appName" + keyword), (String)this.queryRequest.getAppName()));
        }
        if (this.queryRequest.isSlowQuery()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("className" + keyword), (String)SLOW_LOGGER_CLASSNAME));
            if (this.queryRequest.getCost() > 0) {
                boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"cost").gt((Object)this.queryRequest.getCost()));
            }
            if (StringUtils.isNotEmpty((String)this.queryRequest.getSlowQueryType())) {
                boolQuery.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)("message" + keyword), (String)("*" + this.queryRequest.getSlowQueryType() + "*")));
            }
        } else if (StringUtils.isNotEmpty((String)this.queryRequest.getClassName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)("className" + keyword), (String)("*" + this.queryRequest.getClassName() + "*")));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getIp())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("ip" + keyword), (String)this.queryRequest.getIp()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getInstanceId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("instanceId" + keyword), (String)this.queryRequest.getInstanceId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getMethodName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("methodName" + keyword), (String)this.queryRequest.getMethodName()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getLevel())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("level" + keyword), (String)this.queryRequest.getLevel()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getAppId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.appId" + keyword), (String)this.queryRequest.getAppId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getUserName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.userName" + keyword), (String)this.queryRequest.getUserName()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getTenantId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.tenantId" + keyword), (String)this.queryRequest.getTenantId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getOpKey())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.opKey" + keyword), (String)this.queryRequest.getOpKey()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getOpMethod())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.opMethod" + keyword), (String)this.queryRequest.getOpMethod()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getUserID())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.userId" + keyword), (String)this.queryRequest.getUserID()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getAccountId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.accountId" + keyword), (String)this.queryRequest.getAccountId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getTraceId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.traceId" + keyword), (String)this.queryRequest.getTraceId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getFormId())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.formId" + keyword), (String)this.queryRequest.getFormId()));
        }
        if (StringUtils.isNotEmpty((String)this.queryRequest.getFormName())) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("logtags.formName" + keyword), (String)this.queryRequest.getFormName()));
        }
        List<String> time = this.queryRequest.getTime();
        boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"time").gte((Object)time.get(0)).lte((Object)time.get(1)));
        String keywords = this.queryRequest.getKeyword();
        if (StringUtils.isNotEmpty((String)keywords)) {
            String[] keys = keywords.split("\\|\\|");
            BoolQueryBuilder keyQueryBuilder = QueryBuilders.boolQuery();
            for (String key : keys) {
                if (!StringUtils.isNotEmpty((String)key)) continue;
                String keyStr = "*" + key + "*";
                keyQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)("message" + keyword), (String)keyStr));
                keyQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)("message2" + keyword), (String)keyStr));
                keyQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)("stacktrace" + keyword), (String)keyStr));
                keyQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)("stacktrace2" + keyword), (String)keyStr));
            }
            boolQuery.filter((QueryBuilder)keyQueryBuilder);
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.from(this.queryRequest.getFrom());
        sourceBuilder.size(Math.min(this.queryRequest.getSize(), 5000));
        sourceBuilder.sort("time", SortOrder.DESC);
        searchRequest.source(sourceBuilder);
        return sourceBuilder.toString();
    }
}

