/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.log.LogQuery;
import kd.bos.eye.api.log.LogQueryFactory;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.api.log.QueryResult;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class SlowQueryHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private final DateTimeFormatter formatter = LogQueryUtils.getDateTimeFormatter();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        try {
            this.getQueryResult(exchange, response);
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("msg", "query log exception. message: " + e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void getQueryResult(HttpExchange exchange, Map<String, Object> response) throws IllegalAccessException, IOException, InstantiationException, ParseException {
        List<String> time;
        LogQueryRequest req = (LogQueryRequest)ExchangeVueUtils.parsePostJson(exchange, LogQueryRequest.class);
        List<String> list = time = req != null ? req.getTime() : null;
        if (time != null) {
            LocalDateTime beginTime = LocalDateTime.parse(time.get(0), this.formatter);
            LocalDateTime endTime = LocalDateTime.parse(time.get(1), this.formatter);
            LogQuery query = LogQueryFactory.getLogQuery();
            QueryResult result = query.query(req.getAppName(), req.getAppId(), req.getOpKey(), req.getOpMethod(), req.getFormId(), req.getFormName(), req.getClassName(), req.getMethodName(), req.getInstanceId(), req.getTraceId(), req.getUserID(), req.getUserName(), req.getTenantId(), req.getAccountId(), req.getLevel(), req.getSize(), Date.from(beginTime.atZone(ZoneId.systemDefault()).toInstant()), Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()), req.getKeyword(), req.isSlowQuery(), req.getSlowQueryType(), req.getIp(), req.getCost());
            if (result.getCode() == 0) {
                response.put("data", result.getData());
                response.put("code", 0);
            }
        } else {
            response.put("code", -1);
            response.put("msg", LangRes.get((String)"LogQueryHandler_70", (String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
        }
    }
}

