/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log.ruleconfig;

import ch.qos.logback.classic.Level;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.log.ruleconfig.LogRuleConfigDbHelper;
import kd.bos.eye.api.log.ruleconfig.LogRuleExecuteStatus;
import kd.bos.eye.api.log.ruleconfig.LogRuleVo;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.government.Constant;
import kd.bos.logging.logback.filter.LogFilter;
import kd.bos.logging.logback.filter.Rule;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class LoggerRuleMgrService {
    private static final AtomicLong minExpectStartTime = new AtomicLong();
    private static final AtomicLong minExpectEndTime = new AtomicLong();
    private static final ScheduledExecutorService scheduleExecutorService = new ScheduledThreadPoolExecutor(0, new ThreadFactory(){
        private AtomicInteger seq = new AtomicInteger();

        @Override
        public Thread newThread(@NotNull Runnable r) {
            return new Thread(r, "LoggerRuleMgrService_updateRule_" + this.seq.getAndIncrement());
        }
    });
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService("/runtime/monitor/config/logRuleConfig", scene -> {
            HashMap<String, String> rtn = null;
            if ("initDataFromDB".equals(scene)) {
                rtn = new HashMap<String, String>(1);
                rtn.put("updateType", "init");
            } else if ("schedulePullDataFromDB".equals(scene)) {
                long betweenTimeMillis;
                long betweenTimeMillis2;
                long minExpectStartTimeStamp;
                int schedulePeriodSeconds = Constant.MONITOR_CONFIG_SCHEDULE_EXECUTE_SECONDS;
                long inaccurateSeconds = 10L;
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis > (minExpectStartTimeStamp = minExpectStartTime.get())) {
                    rtn = new HashMap(1);
                    rtn.put("updateType", "schedule");
                } else if (minExpectStartTimeStamp + (long)schedulePeriodSeconds * 1000L > currentTimeMillis && (betweenTimeMillis2 = minExpectStartTimeStamp - currentTimeMillis) < ((long)schedulePeriodSeconds - inaccurateSeconds) * 1000L) {
                    scheduleExecutorService.schedule(() -> LoggerRuleMgrService.updateRule("updateType", "schedule"), betweenTimeMillis2, TimeUnit.MILLISECONDS);
                }
                long minExpectEndTimeStamp = minExpectEndTime.get();
                if (currentTimeMillis > minExpectEndTimeStamp) {
                    rtn = new HashMap(1);
                    rtn.put("updateType", "schedule");
                } else if (minExpectEndTimeStamp + (long)schedulePeriodSeconds * 1000L > currentTimeMillis && (betweenTimeMillis = minExpectEndTimeStamp - currentTimeMillis) < ((long)schedulePeriodSeconds - inaccurateSeconds) * 1000L) {
                    scheduleExecutorService.schedule(() -> LoggerRuleMgrService.updateRule("updateType", "schedule"), betweenTimeMillis, TimeUnit.MILLISECONDS);
                }
                DLock dLock = DLock.create((String)"/eye/LoggerRule/updateExecuteStatus");
                try {
                    if (dLock.tryLock()) {
                        LogRuleConfigDbHelper.updateExecuteStatus();
                    }
                }
                finally {
                    dLock.unlock();
                }
            }
            return rtn;
        }, (key, value) -> LoggerRuleMgrService.updateRule(key, value));
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static void updateRule(String key, String value) {
        List<LogRuleVo> enableRule = LogRuleConfigDbHelper.getRuleByStatus("enable", new String[]{LogRuleExecuteStatus.NOT_STARTED.getStatus(), LogRuleExecuteStatus.EXECUTING.getStatus()});
        ArrayList<Rule> ruleList = new ArrayList<Rule>(enableRule.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long currentTimeMillis = System.currentTimeMillis();
        enableRule.forEach(logRuleVo -> {
            Rule rule = new Rule();
            if (StringUtils.isEmpty((String)logRuleVo.getLevelStr())) {
                return;
            }
            rule.setLevelStr(logRuleVo.getLevelStr());
            rule.setLevel(Level.toLevel((String)logRuleVo.getLevelStr(), (Level)Level.ERROR).toInt());
            String effectiveDate = logRuleVo.getEffectiveDate();
            if (StringUtils.isNotEmpty((String)effectiveDate)) {
                try {
                    Date effectiveDateObj = dateFormat.parse(effectiveDate);
                    rule.setStartTime(effectiveDateObj.getTime());
                    String effectiveDuration = logRuleVo.getEffectiveDuration();
                    long duration = Long.parseLong(effectiveDuration);
                    if (duration > 0L) {
                        long endTime = rule.getStartTime() + duration * 60L * 1000L;
                        if (endTime < currentTimeMillis) {
                            return;
                        }
                        rule.setEndTime(endTime);
                    }
                }
                catch (Exception ignore) {
                    return;
                }
            }
            rule.setClassName(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getClassName()));
            rule.setAccountId(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getAccountId()));
            rule.setAppId(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getAppId()));
            rule.setAppName(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getAppName()));
            rule.setFormId(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getFormId()));
            rule.setTenantId(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getTenantId()));
            rule.setUserId(LoggerRuleMgrService.nullIfEmpty(logRuleVo.getUserId()));
            ruleList.add(rule);
        });
        LoggerRuleMgrService.updateRule(ruleList, key);
    }

    private static String nullIfEmpty(String str) {
        return StringUtils.isEmpty((String)str) ? null : str;
    }

    public static void updateRule(List<Rule> ruleList, String key) {
        if (ruleList == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        AtomicLong tempMinExpectStartTime = new AtomicLong(Long.MAX_VALUE);
        AtomicLong tempMinExpectEndTime = new AtomicLong(Long.MAX_VALUE);
        if (!ruleList.isEmpty()) {
            ArrayList<Rule> effectRuleList = new ArrayList<Rule>(ruleList.size());
            ruleList.forEach(rule -> {
                long endTime;
                long startTime = rule.getStartTime();
                if (startTime > 0L && startTime > currentTimeMillis && tempMinExpectStartTime.get() > startTime) {
                    tempMinExpectStartTime.set(startTime);
                }
                if ((endTime = rule.getEndTime()) > 0L && endTime > currentTimeMillis && tempMinExpectEndTime.get() > endTime) {
                    tempMinExpectEndTime.set(endTime);
                }
                rule.updateSort();
                effectRuleList.add((Rule)rule);
            });
            effectRuleList.sort((o1, o2) -> Integer.compare(o2.getSort(), o1.getSort()));
            ruleList = effectRuleList;
        }
        minExpectStartTime.set(tempMinExpectStartTime.get());
        minExpectEndTime.set(tempMinExpectEndTime.get());
        LogFilter.updateRule(ruleList);
        if (!key.equals("updateType") && tempMinExpectStartTime.get() > System.currentTimeMillis()) {
            int schedulePeriodSeconds = Constant.MONITOR_CONFIG_SCHEDULE_EXECUTE_SECONDS;
            long inaccurateSeconds = 10L;
            long betweenTimeMillis = tempMinExpectStartTime.get() - System.currentTimeMillis();
            if (betweenTimeMillis < ((long)schedulePeriodSeconds - inaccurateSeconds) * 1000L) {
                scheduleExecutorService.schedule(() -> LoggerRuleMgrService.updateRule("updateType", "schedule"), betweenTimeMillis, TimeUnit.MILLISECONDS);
            }
        }
    }
}

