/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.checker;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.eye.api.loghealth.entity.config.KafkaConfig;
import kd.bos.eye.api.loghealth.entity.config.LogConfig;
import kd.bos.eye.api.loghealth.entity.config.LogConfigFactory;
import kd.bos.eye.api.loghealth.entity.result.KafkaCheckResult;
import kd.bos.eye.api.loghealth.entity.status.KafkaStatus;
import kd.bos.eye.api.loghealth.helper.kafka.KafkaAdminHelper;
import kd.bos.eye.api.loghealth.helper.kafka.SampleTopicConsumptionInfo;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;

public class KafkaHealthChecker {
    public static KafkaCheckResult check() {
        LogConfig logConfig = LogConfigFactory.getLogConfig();
        KafkaConfig kafkaConfig = logConfig.getKafkaConfig();
        Properties props = kafkaConfig.getKafkaProperties();
        KafkaAdminHelper kafkaAdminHelper = new KafkaAdminHelper(props);
        KafkaCheckResult kafkaCheckResult = new KafkaCheckResult();
        kafkaCheckResult.setTopic(kafkaConfig.getTopic());
        try {
            if (kafkaAdminHelper.isShutdown()) {
                kafkaCheckResult.setKafkaStatus(KafkaStatus.SHUTSOWN);
                kafkaCheckResult.setMessage(KafkaStatus.SHUTSOWN.getDesc());
            } else {
                List<SampleTopicConsumptionInfo> consumptionInfos = KafkaHealthChecker.getSampleTopicConsumptionInfos(kafkaAdminHelper, kafkaConfig.getTopic());
                KafkaStatus topicConsumeStatus = KafkaHealthChecker.getTopicConsumeStatus(consumptionInfos);
                kafkaCheckResult.setKafkaStatus(topicConsumeStatus);
                kafkaCheckResult.setMessage(topicConsumeStatus.getDesc());
                kafkaCheckResult.setSampleTopicConsumptionInfos(consumptionInfos);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kafkaCheckResult;
    }

    public static List<SampleTopicConsumptionInfo> getSampleTopicConsumptionInfos(KafkaAdminHelper kafkaAdminHelper, String topic) {
        ArrayList<SampleTopicConsumptionInfo> sampleInfos = new ArrayList<SampleTopicConsumptionInfo>(3);
        sampleInfos.add(kafkaAdminHelper.getSampleTopicConsumptionInfo(topic));
        LogHealthUtils.waitForSomething(3000L);
        sampleInfos.add(kafkaAdminHelper.getSampleTopicConsumptionInfo(topic));
        return sampleInfos;
    }

    private static KafkaStatus getTopicConsumeStatus(List<SampleTopicConsumptionInfo> consumptionInfos) {
        int start = 0;
        int end = consumptionInfos.size() - 1;
        long curDiff = consumptionInfos.get(end).getCurrentOffset() - consumptionInfos.get(start).getCurrentOffset();
        long endDiff = consumptionInfos.get(end).getEndOffset() - consumptionInfos.get(start).getEndOffset();
        long lag = consumptionInfos.get(end).getLag();
        if (curDiff > 0L && endDiff > 0L && lag < 3000L) {
            return KafkaStatus.FINE;
        }
        if (lag >= 3000L) {
            return KafkaStatus.BACKLOG;
        }
        return KafkaStatus.UNKNOWN;
    }
}

