/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.checker;

import com.alibaba.fastjson.JSONArray;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.api.loghealth.entity.result.LogChainResult;
import kd.bos.eye.api.loghealth.entity.status.LoggingStatus;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LogChainChecker {
    private static final Log logger = LogFactory.getLog(LogChainChecker.class);
    private static final String TEST_MESSAGE = "[log-health-message]: id = ";

    public static LogChainResult check() {
        String id = UUID.randomUUID().toString();
        LogChainResult logChainResult = new LogChainResult();
        String message = TEST_MESSAGE + id;
        logger.error(message);
        LogHealthUtils.waitForSomething(3000L);
        if (LogChainChecker.queryTestLog(id)) {
            logChainResult.setLoggingStatus(LoggingStatus.SUCCESS);
            logChainResult.setLatency("0");
            logChainResult.setMessage(LoggingStatus.SUCCESS.getMessage());
            return logChainResult;
        }
        long logLatency = LogChainChecker.queryLastLogLatency();
        if (logLatency == -1L) {
            logChainResult.setLoggingStatus(LoggingStatus.ERROR);
            logChainResult.setMessage(LoggingStatus.ERROR.getMessage());
        } else {
            logChainResult.setLoggingStatus(LoggingStatus.BLOCKING);
            logChainResult.setLatency(String.valueOf(logLatency));
            logChainResult.setMessage(LoggingStatus.BLOCKING.getMessage());
        }
        return logChainResult;
    }

    private static boolean queryTestLog(String message) {
        LogQueryRequest logQueryRequest = new LogQueryRequest();
        logQueryRequest.setKeyword(message);
        logQueryRequest.setClassName(LogChainChecker.class.getName());
        logQueryRequest.setTime(LogChainChecker.getTimeRange(10));
        logQueryRequest.setSize(1);
        try {
            String result = LogQueryUtils.query(logQueryRequest);
            JSONArray array = LogQueryUtils.jsonToDataArray(result);
            return array.size() > 0;
        }
        catch (Exception e) {
            logger.error("query log for checking log health is failed. ERROR_INFO: ", (Throwable)e);
            return false;
        }
    }

    private static long queryLastLogLatency() {
        LogQueryRequest logQueryRequest = new LogQueryRequest();
        logQueryRequest.setTime(LogChainChecker.getTimeRange(60));
        logQueryRequest.setSize(1);
        try {
            String result = LogQueryUtils.query(logQueryRequest);
            JSONArray array = LogQueryUtils.jsonToDataArray(result);
            if (array.size() == 0) {
                return -1L;
            }
            String time = (String)array.getJSONObject(0).get((Object)"@timestamp");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            LocalDateTime last = LocalDateTime.from(formatter.parse(time));
            Duration duration = Duration.between(last, LocalDateTime.now());
            return duration.toMillis();
        }
        catch (Exception e) {
            logger.error("query log for checking log health is failed. ERROR_INFO: ", (Throwable)e);
            return -1L;
        }
    }

    private static List<String> getTimeRange(int minutes) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusMinutes(minutes).minusHours(8L);
        LocalDateTime end = now.plusMinutes(minutes).minusHours(8L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        ArrayList<String> timeRange = new ArrayList<String>();
        timeRange.add(formatter.format(start));
        timeRange.add(formatter.format(end));
        return timeRange;
    }
}

