/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.helper.logstash;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.loghealth.common.LogHealthConstants;
import kd.bos.eye.api.loghealth.entity.config.LogstashConfig;
import kd.bos.eye.api.loghealth.helper.logstash.SampleLogstashHealthInfo;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class LogstashHealthHelper {
    private static final Log LOGGER = LogFactory.getLog(LogstashHealthHelper.class);
    private final LogstashConfig logstashConfig;

    public LogstashHealthHelper(LogstashConfig logstashConfig) {
        this.logstashConfig = logstashConfig;
    }

    public boolean isShutdown() {
        try {
            HttpClient client = this.createHttpClient();
            String eventsUrl = this.logstashConfig.getUrl() + "/";
            HttpGet get = new HttpGet(eventsUrl);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
            get.setConfig(requestConfig);
            client.execute((HttpUriRequest)get);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public SampleLogstashHealthInfo getLogstashHealthInfo() {
        HttpClient client = this.createHttpClient();
        String eventsUrl = this.logstashConfig.getUrl() + "/_node/stats/events?pretty";
        HttpGet get = new HttpGet(eventsUrl);
        SampleLogstashHealthInfo sampleLogstashHealthInfo = new SampleLogstashHealthInfo();
        sampleLogstashHealthInfo.setSampleTime(LogHealthConstants.DATE_TIME_FOMATTER.format(LocalDateTime.now()));
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).build();
            get.setConfig(requestConfig);
            HttpResponse response = client.execute((HttpUriRequest)get);
            String json = LogHealthUtils.asJson(response.getEntity());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(json);
            JsonNode events = jsonNode.get("events");
            sampleLogstashHealthInfo.setIn(events.get("in").asLong());
            sampleLogstashHealthInfo.setFiltered(events.get("filtered").asLong());
            sampleLogstashHealthInfo.setOut(events.get("out").asLong());
            return sampleLogstashHealthInfo;
        }
        catch (Exception e) {
            return sampleLogstashHealthInfo;
        }
    }

    private HttpClient createHttpClient() {
        CloseableHttpClient client;
        String username = this.logstashConfig.getUser();
        String password = this.logstashConfig.getPassword();
        if (username != null && password != null) {
            password = Encrypters.decode((String)password);
            client = HttpClients.custom().setDefaultCredentialsProvider(this.initCreadentials(username, password)).build();
        } else {
            client = HttpClients.createDefault();
        }
        return client;
    }

    private CredentialsProvider initCreadentials(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }
}

