/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.db.DB;
import kd.bos.eye.api.login.UserRequeset;
import kd.bos.eye.api.login.VerifyCodeHandler;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.api.permission.dao.UserDao;
import kd.bos.eye.api.permission.entity.User;
import kd.bos.eye.api.permission.entity.UserRequest;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.eye.util.PBKDF2Util;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.lang.LangContext;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class LoginApiHandler
implements HttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    public static final LoginApiHandler instance = new LoginApiHandler();

    private String xssClean(String value) {
        if (value != null) {
            return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&ocirc;");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            ThreadTruck.put((Object)"monitor-requestContext-login", (Object)true);
            LangContext.setLangContext((HttpExchange)exchange);
            String aTrue = System.getProperty("monitor.verifyCode.enable", "true");
            String initUser = System.getProperty("monitor.user");
            boolean verifyCodeEnable = Boolean.parseBoolean(aTrue);
            ApiResponse<Serializable> response = new ApiResponse<Serializable>();
            String token = null;
            try {
                UserRequeset request = (UserRequeset)ExchangeVueUtils.parsePostJson(exchange, UserRequeset.class);
                String user = request.getUsername();
                user = this.xssClean(user);
                String password = request.getPassword();
                password = this.xssClean(password);
                if (StringUtils.isEmpty((String)user)) {
                    response.setCode(1);
                    response.setData(null);
                    response.setMsg(LangRes.get((String)"LoginHandler_0", (String)"Username is empty", (Object[])new Object[0]));
                } else if (StringUtils.isEmpty((String)password)) {
                    response.setCode(1);
                    response.setData(null);
                    response.setMsg(LangRes.get((String)"LoginHandler_1", (String)"Password is empty", (Object[])new Object[0]));
                } else if (verifyCodeEnable && !VerifyCodeHandler.checkVerifyCode(this.getVerifyCode(exchange), request.getLoginId())) {
                    response.setCode(1);
                    response.setData(Integer.valueOf(this.getErrorTimes(user)));
                    response.setMsg(LangRes.get((String)"LoginHandler_4", (String)"Incorrect captcha", (Object[])new Object[0]));
                } else {
                    String decryptPassword = MonitorLoginUtils.getDecryptPassword(user, password);
                    if (EyeAuther.checkUser(user, decryptPassword) && !EyeAuther.isLocked(user)) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        if (initUser.equals(user) || !EyeAuther.isExpirePassword(user)) {
                            token = this.writeSession(user, decryptPassword);
                            Integer integer = Integer.getInteger("EYE_HTTP_PORT");
                            data.put("clusterName", Instance.getClusterName());
                            data.put("webPort", integer);
                            data.put("circuitbreaker", System.getProperty("circuitbreaker.type", "armor").toLowerCase());
                            data.put("traceType", System.getProperty("gov.trace.reporter.type", "sword").toLowerCase());
                            response.setMsg("success");
                            response.setCode(0);
                            response.setData(data);
                            this.editUserPassword(user, decryptPassword);
                            OPLOGGER.opLog(this.addLoginLog(exchange, user, true));
                        } else {
                            response.setMsg(LangRes.get((String)"LoginHandler_6", (String)"User password has expired", (Object[])new Object[0]));
                            response.setCode(1);
                        }
                    } else {
                        response.setMsg(LangRes.get((String)"LoginHandler_3", (String)"User does not exist or password is incorrect", (Object[])new Object[0]));
                        response.setCode(1);
                        int errorTimes = this.getErrorTimes(user);
                        response.setData(Integer.valueOf(errorTimes));
                        boolean forbidden = EyeAuther.isForbidden(user);
                        if (forbidden) {
                            response.setMsg(LangRes.get((String)"LoginHandler_5", (String)"User: {0} has reached {1} login attempts, the account is locked, please try again in 30 minutes", (Object[])new Object[]{user, errorTimes}));
                        }
                        this.changeTips(forbidden, response, user, errorTimes);
                        OPLOGGER.opLog(this.addLoginLog(exchange, user, false));
                    }
                }
            }
            catch (Exception e) {
                response.setCode(-1);
                response.setMsg("login exception, message: " + e.getMessage());
            }
            String str = JSONUtils.toString(response);
            this.writeJson(str, exchange, token);
        }
        finally {
            ThreadTruck.current().close();
        }
    }

    private OpLogEntity addLoginLog(HttpExchange exchange, String user, boolean isSuccess) {
        OpLogEntity opLogEntity = new OpLogEntity();
        opLogEntity.setId(DB.genLongId((String)"T_MONITOR_OPLOG"));
        opLogEntity.setUserName(user);
        opLogEntity.setOpTime(LocalDateTime.now());
        opLogEntity.setClientIp(OpLogUtil.getRemoteHost(exchange));
        opLogEntity.setOpType(OpType.EXECUTE.getTypeDescription());
        opLogEntity.setOpObject(LangRes.get((String)"LoginApiHandler_0", (String)"\u767b\u5f55", (Object[])new Object[0]));
        if (isSuccess) {
            opLogEntity.setDescription(LangRes.get((String)"LoginApiHandler_1", (String)"\u767b\u5f55\u6210\u529f", (Object[])new Object[0]));
        } else {
            opLogEntity.setDescription(LangRes.get((String)"LoginApiHandler_2", (String)"\u767b\u5f55\u5931\u8d25", (Object[])new Object[0]));
        }
        return opLogEntity;
    }

    private int getErrorTimes(String userName) {
        String key;
        DistributeSessionableCache cache = SessionStore.get().getCache();
        String oldNum = (String)cache.get(key = "monitor-forbidden-account-" + userName, (Object)userName);
        if (StringUtils.isEmpty((String)oldNum)) {
            return 0;
        }
        return Integer.parseInt(oldNum);
    }

    private void changeTips(boolean forbidden, ApiResponse response, String user, int errorTimes) {
        if (forbidden) {
            response.setMsg(LangRes.get((String)"LoginHandler_5", (String)"User: {0} has reached {1} login attempts, the account is locked, please try again in 30 minutes", (Object[])new Object[]{user, errorTimes}));
        }
    }

    private String writeSession(String user, String password) {
        return EyeAuther.newToken(user, password);
    }

    protected void writeJson(String str, HttpExchange exchange, String token) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        if (StringUtils.isNotEmpty((String)token)) {
            exchange.getResponseHeaders().add("Set-Cookie", this.getSafetyToken(token));
            exchange.getResponseHeaders().add("monitor-csrf-token", EyeAuther.getCsrfToken(token));
        }
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private String getSafetyToken(String token) {
        String safetyToken = Boolean.getBoolean("monitor.add.securehttponly.enable") ? EyeAuther.AUTH_TOKEN + "=" + token + ";path=/;secure;HttpOnly" : EyeAuther.AUTH_TOKEN + "=" + token + ";path=/";
        return safetyToken;
    }

    private String getVerifyCode(HttpExchange exchange) {
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        if (StringUtils.isNotEmpty((String)cookies)) {
            String[] strings;
            for (String item : strings = cookies.split(";")) {
                if (!item.contains("verifyCode")) continue;
                String[] split = item.split("=");
                return split[1];
            }
        }
        return "ERROR";
    }

    private void editUserPassword(String userName, String password) {
        String model = System.getProperty("monitor.dev.model");
        if (!DBHelper.dbIsConfigured() || "debug".equals(model)) {
            return;
        }
        UserDao userDao = new UserDao();
        User user = userDao.getUserByName(userName);
        if (user == null || PBKDF2Util.isEncryptByPbkdf2(user.getUserPassword())) {
            return;
        }
        UserRequest userRequest = new UserRequest();
        userRequest.setId(user.getId());
        userRequest.setUserName(user.getUserName());
        userRequest.setUserPassword(password);
        userRequest.setExpireDate(user.getExpireDate());
        userRequest.setUserDescription(user.getUserDescription());
        userRequest.setUserRole(user.getUserRole());
        userRequest.setUserSource(user.getUserSource());
        userDao.editUser(userRequest);
    }
}

