/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDateTime;
import kd.bos.db.DB;
import kd.bos.eye.api.oplog.OpLogEntity;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogUtil;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class LoginoutApiHandler
extends AbstractHttpHandler {
    public static final LoginoutApiHandler instance = new LoginoutApiHandler();
    public static final String SESSIONKEY = "KD_MONITOR_SESSION";
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(0);
        response.setMsg("success");
        response.setData(null);
        String user = SessionStore.get().get(EyeAuther.getToken(exchange)).get("user");
        String ip = OpLogUtil.getRemoteHost(exchange);
        SessionStore.get().remove(LoginoutApiHandler.getToken(exchange));
        String sessionId = LoginoutApiHandler.getSessionId(exchange);
        if (!StringUtils.isEmpty((String)sessionId)) {
            SessionStore.get().remove(sessionId);
        }
        String str = JSONUtils.toString(response);
        exchange.getResponseHeaders().add("Set-Cookie", EyeAuther.AUTH_TOKEN + "=;path=/;Max-Age=0");
        OPLOGGER.opLog(this.addLogoutLog(user, ip));
        this.writeJson(str, exchange);
    }

    private static String getSessionId(HttpExchange exchange) {
        String[] cookiearry;
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        if (StringUtils.isEmpty((String)cookies)) {
            return null;
        }
        String sessionId = null;
        for (String cookie : cookiearry = cookies.split(";")) {
            if (!(cookie = cookie.replaceAll(" ", "")).startsWith("KD_MONITOR_SESSION=")) continue;
            sessionId = cookie.replace("KD_MONITOR_SESSION=", "").replace(";", "");
        }
        return sessionId;
    }

    private OpLogEntity addLogoutLog(String user, String ip) {
        OpLogEntity opLogEntity = new OpLogEntity();
        opLogEntity.setId(DB.genLongId((String)"T_MONITOR_OPLOG"));
        opLogEntity.setUserName(user);
        opLogEntity.setOpTime(LocalDateTime.now());
        opLogEntity.setClientIp(ip);
        opLogEntity.setOpType(OpType.EXECUTE.getTypeDescription());
        opLogEntity.setOpObject(LangRes.get((String)"LoginoutApiHandler_0", (String)"\u9000\u51fa", (Object[])new Object[0]));
        opLogEntity.setDescription(LangRes.get((String)"LoginoutApiHandler_1", (String)"\u9000\u51fa\u6210\u529f", (Object[])new Object[0]));
        return opLogEntity;
    }
}

