/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.permission.dao.RoleDao;
import kd.bos.eye.api.sso.SsoClients;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeAuth;
import kd.bos.eye.api.sso.cosmiceye.CosmiceyeResponse;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class UserinfoApiHandler
extends AbstractHttpHandler {
    public static final UserinfoApiHandler instance = new UserinfoApiHandler();
    private static final Log logger = LogFactory.getLog(UserinfoApiHandler.class);

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        String token = UserinfoApiHandler.getToken(exchange);
        Map<String, String> userInfo = SessionStore.get().get(token);
        String model = System.getProperty("monitor.dev.model");
        Boolean isConfFromMc = Boolean.parseBoolean(System.getProperty("monitor.db.mcconf.switch", "false"));
        ApiResponse response = new ApiResponse();
        HashMap<String, String> data = new HashMap<String, String>();
        String logintype = userInfo.get("logintype");
        data.put("loginType", logintype);
        data.put("username", userInfo.get("user"));
        String permissionStr = null;
        if ("debug".equals(model)) {
            permissionStr = RoleDao.getAllPermission();
        } else if (logintype.equals(SsoClients.COSMICEYE.getName())) {
            CosmiceyeResponse rs = CosmiceyeAuth.get().getpermissions(token);
            if (rs != null) {
                if (rs.getErrcode() == 0) {
                    permissionStr = (String)rs.getData().get("permissions");
                    logger.info("remote getpermissions, permissions:" + permissionStr);
                } else {
                    logger.error("remote getpermissions error, errorcode = " + rs.getErrcode() + ", description = " + rs.getDescription());
                }
            }
        } else {
            permissionStr = "true".equals(userInfo.get("isFirstLogin")) || "true".equals(userInfo.get("isExpired")) ? (isConfFromMc != false ? "[\"\"]" : "[\"config\",\"config-dbConfig\",\"config-dbConfig-add\",\"config-dbConfig-edit\"]") : (userInfo.get("role") == null ? EyeAuther.getUserPermission(userInfo.get("user")) : EyeAuther.getRolePermission(userInfo.get("role")));
        }
        if (isConfFromMc.booleanValue() && StringUtils.isNotEmpty((String)permissionStr)) {
            JSONArray array = JSON.parseArray((String)permissionStr);
            JSONArray hiddenArray = JSON.parseArray((String)"[\"config-dbConfig\",\"config-dbConfig-add\",\"config-dbConfig-edit\"]");
            if (array != null) {
                array.removeAll((Collection)hiddenArray);
                permissionStr = array.toJSONString();
            }
        }
        data.put("userPermission", permissionStr);
        response.setCode(0);
        response.setMsg("success");
        response.setData(data);
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

