/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.login;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.eye.api.login.MonitorVerifyCode;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.util.ApiResponse;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class VerifyCodeHandler
implements HttpHandler {
    private static final String MONITOR_VERIFY_CODE_CACHE_KEY = "monitor_login_verifyCode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            ThreadTruck.put((Object)"monitor-requestContext-login", (Object)true);
            DistributeSessionableCache cache = SessionStore.get().getCache();
            ApiResponse response = new ApiResponse();
            String aTrue = System.getProperty("monitor.verifyCode.enable", "true");
            boolean verifyCodeEnable = Boolean.parseBoolean(aTrue);
            HashMap<String, Object> vCode = new HashMap<String, Object>();
            String loginId = UUID.randomUUID().toString();
            if (verifyCodeEnable) {
                vCode.put("enable", true);
                MonitorVerifyCode vc = new MonitorVerifyCode();
                BufferedImage bim = vc.getImage();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bim, "JPEG", out);
                String content = Base64.encodeBase64String((byte[])out.toByteArray());
                cache.put(MONITOR_VERIFY_CODE_CACHE_KEY + loginId, (Object)loginId, (Object)vc.getText());
                cache.expireAfter(MONITOR_VERIFY_CODE_CACHE_KEY + loginId, 1800);
                vCode.put("code", "data:image/jpeg;base64," + content);
            } else {
                vCode.put("enable", false);
            }
            vCode.put("ignoreUserPd", this.ignoreUserPd());
            vCode.put("loginId", loginId);
            response.setCode(0);
            response.setData(vCode);
            this.writeResponseJson(exchange, JSONUtils.toString(response));
        }
        finally {
            ThreadTruck.current().close();
        }
    }

    public static boolean checkVerifyCode(String code, String loginId) {
        DistributeSessionableCache cache = SessionStore.get().getCache();
        if (StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)loginId)) {
            return false;
        }
        String key = MONITOR_VERIFY_CODE_CACHE_KEY + loginId;
        String verifyCode = (String)cache.get(key, (Object)loginId);
        if (StringUtils.isEmpty((String)verifyCode)) {
            return false;
        }
        cache.remove(key);
        return verifyCode.equalsIgnoreCase(code);
    }

    private void writeResponseJson(HttpExchange exchange, CharSequence result) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.print(result.toString());
        String str = sw.toString();
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        out.close();
        sw.close();
        exchange.close();
    }

    private boolean ignoreUserPd() {
        boolean ignoreUserPd = Boolean.parseBoolean(System.getProperty("monitor.login.ignoreUserPd.enable", "false"));
        return ignoreUserPd;
    }
}

