/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.memobj;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.memobj.CollectResult;
import kd.bos.eye.api.memobj.CollectTask;
import kd.bos.eye.api.memobj.MemInfoCollector;
import kd.bos.eye.api.memobj.collector.OSMemInfoCollector;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class MemObjInfoApiHandler
extends AbstractHttpHandler {
    private MemInfoCollector collector = new OSMemInfoCollector();
    private static int PID = -1;

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 0;
            }
        }
        return PID;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        String limitStr;
        Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
        CollectTask task = new CollectTask();
        if ("1".equals(params.get("live"))) {
            task.setLive(true);
        }
        task.setNumber(ConfigurationUtil.getInteger((String)"monitor.collectmem.number", (Integer)1000));
        if (!StringUtils.isEmpty((String)params.get("clsName"))) {
            String clsName = params.get("clsName").replaceAll("\\s+", "");
            task.setClsName(clsName);
        }
        task.setPid(MemObjInfoApiHandler.getPid());
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        CollectResult result = this.collector.getMemInfo(task);
        String instOrder = params.get("instOrder");
        String bytesOrder = params.get("bytesOrder");
        if (instOrder != null) {
            if ("descending".equals(instOrder)) {
                result.list.sort((o1, o2) -> {
                    if (o1 == null || o2 == null) {
                        return -1;
                    }
                    return Integer.compare(o2.getInstances(), o1.getInstances());
                });
            } else if ("ascending".equals(instOrder)) {
                result.list.sort((o1, o2) -> {
                    if (o1 == null || o2 == null) {
                        return -1;
                    }
                    return Integer.compare(o1.getInstances(), o2.getInstances());
                });
            }
        }
        if (bytesOrder != null) {
            if ("descending".equals(bytesOrder)) {
                result.list.sort((o1, o2) -> {
                    if (o1 == null || o2 == null) {
                        return -1;
                    }
                    return Long.compare(o2.getBytes(), o1.getBytes());
                });
            } else if ("ascending".equals(bytesOrder)) {
                result.list.sort((o1, o2) -> {
                    if (o1 == null || o2 == null) {
                        return -1;
                    }
                    return Long.compare(o1.getBytes(), o2.getBytes());
                });
            }
        }
        if ((limitStr = params.get("limit")) != null) {
            int limit;
            try {
                limit = Integer.parseInt(params.get("limit"));
            }
            catch (Exception e) {
                limit = 0;
            }
            if (limit > 0 && result.list != null && result.list.size() >= limit) {
                result.list = result.list.subList(0, limit);
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("code", 0);
        response.put("data", result.list);
        response.put("msg", "success");
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

