/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.memobj.collector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.OperationContextCreator;
import kd.bos.eye.api.memobj.CollectResult;
import kd.bos.eye.api.memobj.CollectTask;
import kd.bos.eye.api.memobj.MemInfoCollector;
import kd.bos.eye.api.memobj.Meminfo;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMemInfoCollector
implements MemInfoCollector {
    private static Logger logger = LoggerFactory.getLogger(OSMemInfoCollector.class);
    private static final Pattern pattern = Pattern.compile("[\\S]+");
    private static final String MAGIC = "/";

    @Override
    public CollectResult getMemInfo(CollectTask task) {
        OperationContextCreator.getOrCreateForBos();
        int pid = task.getPid();
        ArrayList<Meminfo> list = new ArrayList<Meminfo>(256);
        String params = " -histo";
        params = task.isLive() ? params + ":live " : params + " ";
        try {
            String cmdPath = ConfigurationUtil.getString((String)"JAVA_HOME");
            String cmd = cmdPath.endsWith(MAGIC) ? cmdPath + "bin/jmap" + params + pid : cmdPath + "/bin/jmap" + params + pid;
            Process ps = Runtime.getRuntime().exec(cmd);
            try (InputStream inputStream = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                boolean startinfo = false;
                while ((line = br.readLine()) != null) {
                    if (line.contains("--------------")) {
                        startinfo = true;
                        continue;
                    }
                    if (!startinfo || line.contains("Total") && !line.contains(":")) continue;
                    Matcher matcher = pattern.matcher(line);
                    int index = 1;
                    Meminfo info = new Meminfo();
                    while (matcher.find()) {
                        if (index == 2) {
                            info.setInstances(Integer.parseInt(matcher.group()));
                        }
                        if (index == 3) {
                            info.setBytes(Long.parseLong(matcher.group()));
                        }
                        if (index == 4) {
                            info.setClsName(matcher.group());
                        }
                        ++index;
                    }
                    if (!StringUtils.isEmpty((String)task.getClsName()) && !info.getClsName().contains(task.getClsName())) continue;
                    list.add(info);
                }
            }
        }
        catch (IOException iex) {
            logger.error("close isr error:", (Throwable)iex);
        }
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage headMemory = memory.getHeapMemoryUsage();
        long used = headMemory.getUsed() / 1024L / 1024L;
        long max = headMemory.getMax() / 1024L / 1024L;
        return new CollectResult(max, used, list);
    }
}

